/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.defect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.core.review.PeerReviewDefectXViewerColumns;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectData;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectRefreshListener;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectXViewerFactory;
import org.eclipse.osee.ats.ide.util.widgets.defect.DefectXViewerMenu;
import org.eclipse.osee.ats.ide.workflow.review.defect.ReviewDefectValidator;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.skynet.widgets.xviewer.IOseeTreeReportProvider;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DefectXViewer
extends XViewer {
    private DefectXViewerMenu defectMenu;
    private final IAtsPeerToPeerReview review;

    public DefectXViewer(Composite parent, int style, IOseeTreeReportProvider reportProvider, IAtsPeerToPeerReview review) {
        this(parent, style, review, (IXViewerFactory)new DefectXViewerFactory(reportProvider, review.getWorkDefinition().getReviewDefectColumns()));
    }

    public DefectXViewer(Composite parent, int style, IAtsPeerToPeerReview review, IXViewerFactory xViewerFactory) {
        super(parent, style, xViewerFactory);
        this.review = review;
    }

    public void loadTable(final DefectData data) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DefectXViewer.this.set(data.getDefectItems());
            }
        });
    }

    public void loadTable(final DefectRefreshListener listener) {
        final DefectData data = new DefectData();
        if (Displays.isDisplayThread()) {
            Jobs.startJob((Job)new Job("Loading Defects"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        DefectXViewer.this.loadDefectData(data);
                        listener.refreshCompleted(data);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    }
                    return Status.OK_STATUS;
                }
            }, (boolean)true);
        } else {
            this.loadDefectData(data);
            listener.refreshCompleted(data);
        }
    }

    private void loadDefectData(DefectData data) {
        data.defectItems = this.review.getDefectManager().getDefectItems();
        data.error = ReviewDefectValidator.isValid(AtsApiService.get().getQueryServiceIde().getArtifact(this.review));
    }

    protected void createSupportWidgets(Composite parent) {
        super.createSupportWidgets(parent);
        parent.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ((DefectContentProvider)DefectXViewer.this.getContentProvider()).clear();
            }
        });
    }

    DefectXViewerMenu getDefectMenu() {
        if (this.defectMenu == null) {
            this.defectMenu = new DefectXViewerMenu(this, this.review);
            this.defectMenu.createMenuActions();
        }
        return this.defectMenu;
    }

    public void updateMenuActionsForTable() {
        MenuManager mm = this.getMenuManager();
        this.getDefectMenu().updateEditMenuActions();
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
    }

    public void add(Collection<ReviewDefectItem> defectItems) {
        if ((DefectContentProvider)this.getContentProvider() != null) {
            ((DefectContentProvider)this.getContentProvider()).add(defectItems);
        }
    }

    public void set(Collection<? extends ReviewDefectItem> defectItems) {
        if ((DefectContentProvider)this.getContentProvider() != null) {
            ((DefectContentProvider)this.getContentProvider()).set(defectItems);
        }
    }

    public void clear() {
        if ((DefectContentProvider)this.getContentProvider() != null) {
            ((DefectContentProvider)this.getContentProvider()).clear();
        }
    }

    public void dispose() {
        this.getLabelProvider().dispose();
    }

    public List<ReviewDefectItem> getSelectedDefectItems() {
        ArrayList<ReviewDefectItem> arts = new ArrayList<ReviewDefectItem>();
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem[] treeItemArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem item = treeItemArray[n2];
                arts.add((ReviewDefectItem)item.getData());
                ++n2;
            }
        }
        return arts;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        if (!this.isEditable()) {
            return;
        }
        ArrayList<ReviewDefectItem> defectItems = new ArrayList<ReviewDefectItem>();
        for (TreeItem item : treeItems) {
            defectItems.add((ReviewDefectItem)item.getData());
        }
        try {
            this.getDefectMenu().promptChangeData((XViewerColumn)treeColumn.getData(), defectItems, this.isColumnMultiEditEnabled());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    public boolean handleLeftClickInIconArea(TreeColumn treeColumn, TreeItem treeItem) {
        XViewerColumn xCol = (XViewerColumn)treeColumn.getData();
        if (xCol.equals((Object)PeerReviewDefectXViewerColumns.User_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Disposition_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Injection_Activity_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Closed_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Severity_Col)) {
            return this.handleAltLeftClick(treeColumn, treeItem);
        }
        return false;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (!this.isEditable()) {
            return false;
        }
        try {
            XViewerColumn xCol = (XViewerColumn)treeColumn.getData();
            ReviewDefectItem defectItem = (ReviewDefectItem)treeItem.getData();
            ArrayList<ReviewDefectItem> defectItems = new ArrayList<ReviewDefectItem>();
            defectItems.add(defectItem);
            if (xCol.equals((Object)PeerReviewDefectXViewerColumns.Severity_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Disposition_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Created_Date_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Closed_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Description_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Resolution_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Location_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.User_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Injection_Activity_Col) || xCol.equals((Object)PeerReviewDefectXViewerColumns.Notes_Col)) {
                return this.getDefectMenu().promptChangeData(xCol, defectItems, false);
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public boolean isEditable() {
        return this.review.isInWork();
    }
}

