/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ActionableItemTreeContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ActionableItemTreeWithChildrenDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.skynet.widgets.XHyperlinkLabelCmdValueSelection;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateFilteredTreeDialog;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.CheckBoxStateTreeLabelProvider;
import org.eclipse.osee.framework.ui.skynet.widgets.checkbox.ICheckBoxStateTreeViewer;

public class XHyperlabelActionableItemSelection
extends XHyperlinkLabelCmdValueSelection {
    Collection<IAtsActionableItem> selectedAis = new HashSet<IAtsActionableItem>();
    Collection<IAtsActionableItem> ais;
    ActionableItemTreeWithChildrenDialog dialog = null;

    public XHyperlabelActionableItemSelection() {
        this("Actionable Item(s)");
    }

    public XHyperlabelActionableItemSelection(String label) {
        super(label, true, Integer.valueOf(80));
    }

    public Collection<IAtsActionableItem> getSelectedActionableItems() {
        return this.selectedAis;
    }

    public Object getData() {
        List arts = Collections.castAll(this.getSelectedActionableItems());
        return arts;
    }

    public String getCurrentValue() {
        return Collections.toString((String)", ", this.selectedAis);
    }

    public void setSelectedAIs(Collection<IAtsActionableItem> selectedAIs) {
        this.selectedAis = selectedAIs;
        this.refresh();
        this.notifyXModifiedListeners();
    }

    public boolean handleClear() {
        this.selectedAis.clear();
        this.notifyXModifiedListeners();
        return true;
    }

    public boolean handleSelection() {
        try {
            AiLabelProvider labelProvider = new AiLabelProvider(null);
            CheckBoxStateFilteredTreeDialog dialog = new CheckBoxStateFilteredTreeDialog("Select Actionable Item(s)", "Select Actionable Item(s)", (IContentProvider)new ActionableItemTreeContentProvider(Active.Both), (CheckBoxStateTreeLabelProvider)labelProvider);
            labelProvider.setTreeViewer((ICheckBoxStateTreeViewer)dialog.getTreeViewer());
            if (this.ais == null) {
                dialog.setInput((Object)AtsApiService.get().getActionableItemService().getTopLevelActionableItems(Active.Active));
            } else {
                dialog.setInput(this.ais);
            }
            int result = dialog.open();
            if (result == 0) {
                this.selectedAis.clear();
                for (IAtsActionableItem ai : dialog.getChecked()) {
                    if (!ai.isActive() || !ai.isActionable()) continue;
                    this.selectedAis.add(ai);
                }
                this.notifyXModifiedListeners();
            }
            return true;
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            return false;
        }
    }

    public boolean isEmpty() {
        return this.selectedAis.isEmpty();
    }

    public IStatus isValid() {
        IStatus status = super.isValid();
        if (this.isRequiredEntry() && this.selectedAis.isEmpty()) {
            status = new Status(4, "org.eclipse.osee.ats.ide", "Must Select Actionable Item(s)");
        }
        return status;
    }

    public Collection<IAtsActionableItem> getAis() {
        return this.ais;
    }

    public void setAis(Collection<IAtsActionableItem> ais) {
        this.ais = ais;
    }

    public static class AiLabelProvider
    extends CheckBoxStateTreeLabelProvider {
        public AiLabelProvider(ICheckBoxStateTreeViewer treeViewer) {
            super(treeViewer);
        }

        protected boolean isEnabled(Object element) {
            return ((IAtsActionableItem)element).isActive() && ((IAtsActionableItem)element).isActionable();
        }
    }
}

