/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.ViewBranchViewFilterTreeDialog;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreTupleTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.branch.ViewApplicabilityUtil;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.orcs.rest.model.ApplicabilityEndpoint;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class XBranchViewSelect
extends GenericXWidget {
    private static final String NOT_SELECTED = "--Not Selected--";
    private Text text;
    private Button setBranchViewButton;
    private Artifact artifact;

    public XBranchViewSelect(String label) {
        super(label);
    }

    public XBranchViewSelect(Artifact artifact, String label) {
        super(label);
        this.artifact = artifact;
    }

    public Control getControl() {
        return null;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        if (horizontalSpan < 2) {
            horizontalSpan = 2;
        }
        Composite applicabilityComp = new Composite(parent, 0);
        applicabilityComp.setLayout((Layout)new GridLayout(2, false));
        applicabilityComp.setLayoutData((Object)new GridData(1, 4, true, false));
        if (this.toolkit != null) {
            this.toolkit.adapt(applicabilityComp);
        }
        this.setBranchViewButton = new Button(applicabilityComp, 8);
        this.setBranchViewButton.setToolTipText("Select a branch view to associate this version artifact with.");
        this.setBranchViewButton.setText("Select Branch View");
        this.setBranchViewButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    String baselineBranch = (String)XBranchViewSelect.this.artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.BaselineBranchId, (Object)"");
                    XBranchViewSelect.this.changeView(BranchId.valueOf((String)baselineBranch));
                    XBranchViewSelect.this.refresh();
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.text = new Text(applicabilityComp, 64);
        this.text.setForeground(Displays.getSystemColor((int)16));
        this.text.setText(this.getArtifactViewApplicabiltyText());
    }

    private String getArtifactViewApplicabiltyText() {
        String result = NOT_SELECTED;
        ApplicabilityEndpoint applEndpoint = ViewApplicabilityUtil.getApplicabilityEndpoint((BranchId)this.artifact.getBranch());
        if (applEndpoint == null) {
            result = "Error: Applicabilty Service not found";
        } else {
            try {
                ArtifactId versionConfig = applEndpoint.getVersionConfig((ArtifactId)this.artifact);
                String baselineBranch = (String)this.artifact.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.BaselineBranchId, (Object)"");
                result = versionConfig.isInvalid() || BranchId.valueOf((String)baselineBranch).isInvalid() ? "Not Set" : ArtifactQuery.getArtifactTokenFromId((BranchId)BranchId.valueOf((String)baselineBranch), (ArtifactId)versionConfig).getName();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                result = "Error retrieving applicability. (see log)";
            }
        }
        return result == null ? NOT_SELECTED : result;
    }

    private boolean changeView(BranchId branch) {
        Map branchViews = ViewApplicabilityUtil.getBranchViews((BranchId)branch);
        ViewBranchViewFilterTreeDialog dialog = new ViewBranchViewFilterTreeDialog("Select Branch View", "Select Branch View", branchViews);
        ArrayList<String> values = new ArrayList<String>();
        values.add("<Clear View Selection>");
        values.addAll(branchViews.values());
        dialog.setInput(values);
        dialog.setMultiSelect(false);
        int result = dialog.open();
        if (result == 0) {
            AtsApiService.get().getServerEndpoints().getTupleEp().addTuple2(CoreTupleTypes.VersionConfig, (Object)ArtifactId.create((Id)this.artifact), (Object)ArtifactId.valueOf((Long)dialog.getSelection()));
            return true;
        }
        return false;
    }

    public void refresh() {
        this.text.setText(this.getArtifactViewApplicabiltyText());
    }
}

