/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.Import;

import java.io.InputStreamReader;
import java.net.URI;
import java.util.Date;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.attribute.AttributeTypeManager;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelAtsTaskArtifactExtractor {
    private final AbstractWorkflowArtifact sma;
    private IProgressMonitor monitor;
    private final NewTaskData newTaskData;

    public ExcelAtsTaskArtifactExtractor(TeamWorkFlowArtifact artifact, NewTaskData newTaskData) {
        this.newTaskData = newTaskData;
        this.sma = artifact;
    }

    public void process(URI source, XResultData rd) throws Throwable {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStreamReader inputStream = new InputStreamReader(source.toURL().openStream(), "UTF-8");){
                IProgressMonitor monitor = this.getMonitor();
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                xmlReader.setContentHandler((ContentHandler)new ExcelSaxHandler((RowProcessor)new InternalRowProcessor(monitor, this.newTaskData, this.sma, rd), true));
                xmlReader.parse(new InputSource(inputStream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            rd.errorf("Exception processing Excel input %s\n", new Object[]{Lib.exceptionToString((Exception)ex)});
        }
    }

    public String getDescription() {
        return "Extract each row as a task";
    }

    public IProgressMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public String getName() {
        return "Excel Ats Tasks";
    }

    private static final class InternalRowProcessor
    implements RowProcessor {
        private String[] headerRow;
        private int rowNum;
        private final IProgressMonitor monitor;
        private final Date createdDate;
        private final AtsUser createdBy;
        private final NewTaskData newTaskData;
        private XResultData rd;
        private Integer badColumn;
        private boolean skipRestOfRows;

        protected InternalRowProcessor(IProgressMonitor monitor, NewTaskData newTaskData, AbstractWorkflowArtifact sma) {
            this.monitor = monitor;
            this.newTaskData = newTaskData;
            this.createdDate = new Date();
            this.createdBy = AtsApiService.get().getUserService().getCurrentUser();
        }

        protected InternalRowProcessor(IProgressMonitor monitor, NewTaskData newTaskData, AbstractWorkflowArtifact sma, XResultData rd) {
            this(monitor, newTaskData, sma);
            this.rd = rd;
            this.rd.setLogToSysErr(true);
        }

        public void processEmptyRow() {
        }

        public void processCommentRow(String[] row) {
        }

        public void reachedEndOfWorksheet() {
        }

        public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
        }

        public void foundStartOfWorksheet(String sheetName) {
        }

        public void processHeaderRow(String[] headerRow) {
            this.headerRow = (String[])headerRow.clone();
            ++this.rowNum;
        }

        public void processRow(String[] row) {
            if (this.skipRestOfRows) {
                return;
            }
            ++this.rowNum;
            this.monitor.setTaskName("Processing Row " + this.rowNum);
            JaxAtsTask jTask = JaxAtsTask.create((NewTaskData)this.newTaskData, (String)"", (AtsUser)this.createdBy, (Date)this.createdDate);
            this.monitor.subTask("Validating...");
            if (!"Title".equals(this.headerRow[0])) {
                this.rd.errorf("Title column must be first\n", new Object[]{this.rowNum});
                this.skipRestOfRows = true;
                return;
            }
            int i = 0;
            while (i < row.length) {
                if (this.badColumn != null && i >= this.badColumn) break;
                String header = this.headerRow[i];
                if (header == null) {
                    this.badColumn = i;
                    break;
                }
                if (header.equalsIgnoreCase("Created By")) {
                    if (this.validRow(jTask)) {
                        this.processCreatedBy(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Title")) {
                    boolean validTitle = this.processTitle(row, jTask, i);
                    if (!validTitle) {
                        this.newTaskData.getTasks().remove(jTask);
                        this.skipRestOfRows = true;
                    }
                } else if (header.equalsIgnoreCase("Assignees")) {
                    if (this.validRow(jTask)) {
                        this.processAssignees(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Resolution")) {
                    if (this.validRow(jTask)) {
                        this.processResolution(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Description")) {
                    if (this.validRow(jTask)) {
                        this.processDescription(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Related to State")) {
                    if (this.validRow(jTask)) {
                        this.processRelatedToState(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Notes")) {
                    if (this.validRow(jTask)) {
                        this.processNotes(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Percent Complete")) {
                    if (this.validRow(jTask)) {
                        this.processPercentComplete(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Hours Spent")) {
                    if (this.validRow(jTask)) {
                        this.processHoursSpent(row, jTask, i);
                    }
                } else if (header.equalsIgnoreCase("Estimated Hours")) {
                    if (this.validRow(jTask)) {
                        this.processEstimatedHours(row, jTask, i);
                    }
                } else if (this.validRow(jTask)) {
                    String attrTypeName = header;
                    if (Strings.isValid((String)attrTypeName)) {
                        AttributeTypeToken attributeType = AttributeTypeManager.getType((String)attrTypeName);
                        if (attributeType == null) {
                            this.rd.error("Invalid Attribute Type Name => " + header);
                        } else if (!AtsArtifactTypes.Task.isValidAttributeType((AttributeTypeId)attributeType)) {
                            this.rd.error("Invalid Attribute Type for Task => " + header);
                        } else {
                            String value = row[i];
                            if (Strings.isValid((String)value)) {
                                jTask.addAttribute(attributeType, (Object)value);
                            }
                        }
                    } else {
                        this.rd.error("Unhandled column => " + header);
                    }
                }
                ++i;
            }
        }

        private boolean validRow(JaxAtsTask task) {
            boolean valid = Strings.isValid((String)task.getName());
            if (!valid) {
                this.newTaskData.getTasks().remove(task);
                this.skipRestOfRows = true;
            }
            return valid;
        }

        private boolean processTitle(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            if (Strings.isValid((String)str)) {
                this.monitor.subTask(String.format("Title \"%s\"", str));
                if (this.newTaskData.isFixTitles().booleanValue()) {
                    if (!Strings.isPrintable((String)str)) {
                        str = Strings.removeNonPrintableCharacters((String)str);
                        this.rd.logf("On row: %d, removed non-printable title characters\n", new Object[]{this.rowNum});
                    }
                    if (str.contains("[\r\n]+")) {
                        str = jTask.getName().replaceAll("[\r\n]+", "");
                        this.rd.logf("On row: %d, removed title newlines\n", new Object[]{this.rowNum});
                    }
                    if (str.length() > 250) {
                        String desc = row[i];
                        str = Strings.truncate((String)str, (int)250, (boolean)true);
                        jTask.setDescription(desc);
                        this.rd.logf("On row: %d, truncated title and put full in description\n", new Object[]{this.rowNum});
                    }
                } else {
                    if (!Strings.isPrintable((String)str)) {
                        this.rd.errorf("On row: %d, title field has non-printable characters\n", new Object[]{this.rowNum});
                        return false;
                    }
                    if (str.contains("[\r\n]+")) {
                        this.rd.errorf("On row: %d, title field cannot have new line characters\n", new Object[]{this.rowNum});
                        return false;
                    }
                    if (str.length() > 250) {
                        this.rd.errorf("On row: %d, title field cannot be longer than 250\n", new Object[]{this.rowNum});
                        return false;
                    }
                }
                if (Strings.isInValid((String)str)) {
                    this.rd.errorf("On row: %d, title is invalid\n", new Object[]{this.rowNum});
                }
                jTask.setName(str);
                return true;
            }
            this.rd.errorf("On row: %d, title field cannot be empty\n", new Object[]{this.rowNum});
            return false;
        }

        private void processNotes(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            if (Strings.isValid((String)str)) {
                jTask.addAttribute((AttributeTypeToken)AtsAttributeTypes.WorkflowNotes, (Object)str);
            }
        }

        private void processRelatedToState(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            if (Strings.isValid((String)str)) {
                jTask.addAttribute((AttributeTypeToken)AtsAttributeTypes.RelatedToState, (Object)str);
            }
        }

        private void processDescription(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            if (Strings.isInValid((String)str)) {
                this.rd.errorf("Description column can not be blank for row %s\n", new Object[]{this.rowNum});
                return;
            }
            jTask.addAttribute((AttributeTypeToken)AtsAttributeTypes.Description, (Object)str);
        }

        private void processResolution(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            if (Strings.isValid((String)str)) {
                jTask.addAttribute((AttributeTypeToken)AtsAttributeTypes.Resolution, (Object)str);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void processCreatedBy(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            if (!Strings.isValid((String)str)) {
                this.rd.errorf("On row: %d, createdBy field cannot be empty\n", new Object[]{this.rowNum});
                return;
            }
            AtsUser user = null;
            try {
                user = AtsApiService.get().getUserService().getUserByUserId(str);
            }
            catch (Exception exception) {
                this.rd.errorf("On row: %d, the user entered in createdBy does not exist\n", new Object[]{this.rowNum});
                return;
            }
            if (user == null) {
                try {
                    user = AtsApiService.get().getUserService().getUserByName(str);
                }
                catch (Exception exception) {
                    this.rd.errorf("On row: %d, the user entered in createdBy does not exist\n", new Object[]{this.rowNum});
                    return;
                }
            }
            if (user != null) {
                jTask.setCreatedByUserId(user.getUserId());
                return;
            }
            this.rd.errorf("On row: %d, the user entered in createdBy does not exist\n", new Object[]{this.rowNum});
        }

        private void processEstimatedHours(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            double hours = 0.0;
            if (Strings.isValid((String)str)) {
                try {
                    hours = Double.valueOf(str);
                }
                catch (Exception exception) {
                    this.rd.errorf("Invalid Estimated Hours \"%s\" for row %d\n", new Object[]{str, this.rowNum});
                }
                jTask.addAttribute((AttributeTypeToken)AtsAttributeTypes.EstimatedHours, (Object)hours);
            }
        }

        private void processHoursSpent(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            double hours = 0.0;
            if (Strings.isValid((String)str)) {
                try {
                    hours = Double.valueOf(str);
                }
                catch (Exception exception) {
                    this.rd.errorf("Invalid Hours Spent \"%s\" for row %d\n", new Object[]{str, this.rowNum});
                }
                jTask.setHoursSpent(Double.valueOf(hours));
            }
        }

        private void processPercentComplete(String[] row, JaxAtsTask jTask, int i) {
            String str = row[i];
            Double percent = 0.0;
            if (Strings.isValid((String)str)) {
                try {
                    percent = Double.valueOf(str);
                    if (percent < 1.0) {
                        percent = percent * 100.0;
                    }
                }
                catch (Exception exception) {
                    this.rd.errorf("Invalid Percent Complete \"%s\" for row %d\n", new Object[]{str, this.rowNum});
                }
                jTask.addAttribute((AttributeTypeToken)AtsAttributeTypes.PercentComplete, (Object)percent);
            }
        }

        private void processAssignees(String[] row, JaxAtsTask jTask, int i) {
            if (row[i] == null) {
                this.rd.errorf("Assignee column can not be blank for row %s\n", new Object[]{this.rowNum});
                return;
            }
            String[] stringArray = row[i].split(";");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String userName = stringArray[n2];
                userName = userName.replaceAll("^\\s+", "");
                userName = userName.replaceAll("\\+$", "");
                AtsUser user = null;
                if (!Strings.isValid((String)userName)) {
                    user = AtsApiService.get().getUserService().getCurrentUser();
                } else {
                    try {
                        user = AtsApiService.get().getUserService().getUserByName(userName);
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
                if (user == null) {
                    user = AtsApiService.get().getUserService().getCurrentUser();
                    this.rd.errorf("Invalid Assignee \"%s\" for row %d.  Using current user\n", new Object[]{userName, this.rowNum});
                }
                jTask.addAssigneeUserIds(user.getUserId());
                ++n2;
            }
        }
    }
}

