/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.ui.skynet.util.DbConnectionUtility;

public class AtsBulkLoad {
    private static AtomicBoolean atsTypeDataLoadedStarted = new AtomicBoolean(false);

    public static List<IOperation> getConfigLoadingOperations() {
        ArrayList<IOperation> ops = new ArrayList<IOperation>();
        if (atsTypeDataLoadedStarted.compareAndSet(false, true) && DbConnectionUtility.isVersionSupported()) {
            AbstractOperation op = new AbstractOperation("Re-load ATS Config", "org.eclipse.osee.ats.ide"){

                protected void doWork(IProgressMonitor monitor) throws Exception {
                    AtsApiService.get().clearCaches();
                    AtsApiService.get().getUserService().getCurrentUser();
                    AtsApiService.get().getConfigService().getConfigurations();
                }
            };
            ops.add((IOperation)op);
        } else {
            ops.add(Operations.createNoOpOperation((String)"ATS Bulk Loading"));
        }
        return ops;
    }

    public static Set<Artifact> bulkLoadArtifacts(Collection<? extends Artifact> artifacts) {
        ArrayList<Artifact> actions = new ArrayList<Artifact>();
        ArrayList<Artifact> teams = new ArrayList<Artifact>();
        ArrayList<Artifact> tasks = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Action})) {
                actions.add(artifact);
                continue;
            }
            if (artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) {
                teams.add(artifact);
                continue;
            }
            if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.Task})) continue;
            tasks.add(artifact);
        }
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        if (!actions.isEmpty()) {
            hashSet.addAll(RelationManager.getRelatedArtifacts(actions, (int)3, (RelationTypeSide[])new RelationTypeSide[]{AtsRelationTypes.TeamWfToTask_Task, AtsRelationTypes.TeamWorkflowToReview_Review, AtsRelationTypes.ActionToWorkflow_Action}));
        }
        if (!teams.isEmpty()) {
            hashSet.addAll(RelationManager.getRelatedArtifacts(teams, (int)4, (RelationTypeSide[])new RelationTypeSide[]{AtsRelationTypes.TeamWfToTask_Task, AtsRelationTypes.ActionToWorkflow_TeamWorkflow, AtsRelationTypes.TeamWorkflowToReview_Review, AtsRelationTypes.AgileFeatureToItem_AgileFeatureGroup, AtsRelationTypes.TeamWorkflowTargetedForVersion_Version}));
        }
        if (!tasks.isEmpty()) {
            hashSet.addAll(RelationManager.getRelatedArtifacts(tasks, (int)2, (RelationTypeSide[])new RelationTypeSide[]{AtsRelationTypes.TeamWfToTask_TeamWorkflow, AtsRelationTypes.ActionToWorkflow_TeamWorkflow}));
        }
        hashSet.addAll(artifacts);
        return hashSet;
    }

    public static void bulkLoadSiblings(Collection<? extends Artifact> artifacts) {
        int n;
        ArrayList<Artifact> teams = new ArrayList<Artifact>();
        for (Artifact artifact : artifacts) {
            if (!artifact.isOfType(new ArtifactTypeId[]{AtsArtifactTypes.TeamWorkflow})) continue;
            teams.add(artifact);
        }
        int n2 = 400;
        String siblingQueryCountStr = AtsApiService.get().getConfigValue("siblingQueryCount");
        if (Strings.isNumeric((String)siblingQueryCountStr)) {
            n = Integer.valueOf(siblingQueryCountStr);
        }
        List artSets = Collections.subDivide(teams, (int)n);
        for (Collection arts : artSets) {
            HashCollection artifactTokenListFromRelated = ArtifactQuery.getArtifactTokenListFromRelated((BranchToken)CoreBranches.COMMON, (Collection)Collections.castAll((Collection)arts), (ArtifactTypeId)AtsArtifactTypes.Action, (RelationTypeSide)AtsRelationTypes.ActionToWorkflow_Action);
            List actionArts = ArtifactQuery.getArtifactListFrom((Collection)artifactTokenListFromRelated.getValues(), (BranchId)CoreBranches.COMMON);
            ArtifactQuery.getArtifactTokenListFromRelated((BranchToken)CoreBranches.COMMON, (Collection)Collections.castAll((Collection)actionArts), (ArtifactTypeId)AtsArtifactTypes.TeamWorkflow, (RelationTypeSide)AtsRelationTypes.ActionToWorkflow_TeamWorkflow);
        }
    }
}

