/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column;

import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.util.LogUtil;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class RemainingHoursColumn
extends XViewerAtsColumn
implements IXViewerValueColumn,
IAltLeftClickProvider {
    public static RemainingHoursColumn instance = new RemainingHoursColumn();

    public static RemainingHoursColumn getInstance() {
        return instance;
    }

    private RemainingHoursColumn() {
        super("ats.column.remainingHours", "Remaining Hours", 40, XViewerAlign.Center, false, SortDataType.Float, false, "Hours that remain to complete the changes.\n\nEstimated Hours - (Estimated Hours * Percent Complete).");
    }

    public RemainingHoursColumn copy() {
        RemainingHoursColumn newXCol = new RemainingHoursColumn();
        super.copy(this, newXCol);
        return newXCol;
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        if (element instanceof AbstractWorkflowArtifact) {
            try {
                Result result = RemainingHoursColumn.isRemainingHoursValid(element);
                if (result.isFalse()) {
                    return result.getText();
                }
                return AtsUtil.doubleToI18nString((double)RemainingHoursColumn.getRemainingHours(element));
            }
            catch (OseeCoreException ex) {
                LogUtil.getCellExceptionString((Exception)((Object)ex));
            }
        }
        return "";
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        try {
            AbstractWorkflowArtifact aba = null;
            if (treeItem.getData() instanceof AbstractWorkflowArtifact) {
                aba = (AbstractWorkflowArtifact)((Object)treeItem.getData());
            } else if (Artifacts.isOfType((Object)treeItem.getData(), (ArtifactTypeToken)AtsArtifactTypes.Action) && AtsApiService.get().getWorkItemService().getTeams(treeItem.getData()).size() == 1) {
                aba = (AbstractWorkflowArtifact)AtsApiService.get().getWorkItemService().getFirstTeam(treeItem.getData()).getStoreObject();
            }
            if (aba != null) {
                AWorkbench.popup((String)"Calculated Field", (String)"Hours Remaining field is calculated.\nHour Estimate - (Hour Estimate * Percent Complete)");
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return false;
    }

    public static Result isRemainingHoursValid(Object object) {
        if (object instanceof AbstractWorkflowArtifact) {
            AbstractWorkflowArtifact aba = (AbstractWorkflowArtifact)((Object)object);
            if (!aba.isAttributeTypeValid((AttributeTypeId)AtsAttributeTypes.EstimatedHours)) {
                return Result.TrueResult;
            }
            try {
                Double value = (Double)aba.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.EstimatedHours, null);
                if (aba.isCancelled()) {
                    return Result.TrueResult;
                }
                if (value == null) {
                    return new Result("Estimated Hours not set.");
                }
                return Result.TrueResult;
            }
            catch (Exception ex) {
                return new Result(String.valueOf(ex.getClass().getName()) + ": " + ex.getLocalizedMessage() + "\n\n" + Lib.exceptionToString((Exception)ex));
            }
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                if (RemainingHoursColumn.isRemainingHoursValid(team).isFalse()) continue;
                return Result.FalseResult;
            }
        }
        return Result.FalseResult;
    }

    public static double getRemainingHours(Object object) {
        if (object instanceof AbstractWorkflowArtifact) {
            return AtsApiService.get().getEarnedValueService().getRemainHoursTotal((IAtsWorkItem)((AbstractWorkflowArtifact)((Object)object)));
        }
        if (Artifacts.isOfType((Object)object, (ArtifactTypeToken)AtsArtifactTypes.Action)) {
            double hours = 0.0;
            for (IAtsTeamWorkflow team : AtsApiService.get().getWorkItemService().getTeams(object)) {
                hours += RemainingHoursColumn.getRemainingHours(team);
            }
            return hours;
        }
        return 0.0;
    }
}

