/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util;

import java.io.File;
import java.util.Scanner;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;

public class DeleteLocalDatabaseDirs {
    public void run() {
        String homeDir = System.getProperty("user.home");
        File homeFile = new File(homeDir);
        if (!homeFile.exists()) {
            XConsoleLogger.out((String)"User home [%s] doesn't exist; Aborting\n", (Object[])new Object[]{homeDir});
            return;
        }
        XConsoleLogger.out((String)"Using home dir [%s]\n", (Object[])new Object[]{homeDir});
        File hsqlDir = new File(String.valueOf(homeDir) + "/hsql");
        boolean hsqlExists = false;
        if (hsqlDir.exists()) {
            hsqlExists = true;
            XConsoleLogger.out((String)"Using found hsql dir [%s]\n", (Object[])new Object[]{hsqlDir.getAbsolutePath()});
        } else {
            XConsoleLogger.out((String)"No hsql dir [%s]\n", (Object[])new Object[]{hsqlDir.getAbsolutePath()});
        }
        File attrDir = new File(String.valueOf(homeDir) + "/attr");
        boolean attrExists = false;
        if (attrDir.exists()) {
            attrExists = true;
            XConsoleLogger.out((String)"Using found attr dir [%s]\n", (Object[])new Object[]{attrDir.getAbsolutePath()});
        } else {
            XConsoleLogger.out((String)"No attr dir [%s]\n", (Object[])new Object[]{attrDir.getAbsolutePath()});
        }
        File demoDir = new File(String.valueOf(homeDir) + "/AppData/Local/OSEE Development Alpha/demo");
        boolean demoExists = false;
        if (demoDir.exists()) {
            demoExists = true;
            XConsoleLogger.out((String)"Using found demo dir [%s]\n", (Object[])new Object[]{demoDir.getAbsolutePath()});
        } else {
            XConsoleLogger.out((String)"No demo dir [%s]\n", (Object[])new Object[]{demoDir.getAbsolutePath()});
        }
        File demoDir2 = new File(String.valueOf(homeDir) + "/Documents/demo");
        boolean demo2Exists = false;
        if (demoDir2.exists()) {
            demo2Exists = true;
            XConsoleLogger.out((String)"Using found demo dir [%s]\n", (Object[])new Object[]{demoDir2.getAbsolutePath()});
        } else {
            XConsoleLogger.out((String)"No demo dir [%s]\n", (Object[])new Object[]{demoDir2.getAbsolutePath()});
        }
        if (!(hsqlExists || attrExists || demoExists)) {
            XConsoleLogger.out((String)"No dirs to delete\nComplete", (Object[])new Object[0]);
            return;
        }
        try (Scanner scanner = null;){
            scanner = new Scanner(System.in);
            XConsoleLogger.out((String)"Delete local hsql/attr/demo database dirs\n(Stop servers/clients first)? (y/n): ", (Object[])new Object[0]);
            String inputString = scanner.nextLine();
            if (inputString.equals("y")) {
                if (hsqlExists) {
                    this.deleteDirectory(hsqlDir);
                }
                if (attrExists) {
                    this.deleteDirectory(attrDir);
                }
                if (demoExists) {
                    this.deleteDirectory(demoDir);
                }
                if (demo2Exists) {
                    this.deleteDirectory(demoDir2);
                }
                XConsoleLogger.out((String)"Complete", (Object[])new Object[0]);
            } else {
                XConsoleLogger.out((String)"Aborted", (Object[])new Object[0]);
            }
        }
    }

    boolean deleteDirectory(File dir) {
        File[] contents = dir.listFiles();
        if (contents != null) {
            File[] fileArray = contents;
            int n = contents.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.deleteDirectory(file);
                ++n2;
            }
        }
        return dir.delete();
    }

    public static void main(String[] args) {
        try (Scanner scanner = null;){
            scanner = new Scanner(System.in);
            XConsoleLogger.out((String)"Delete local hsql/attr/demo database dirs\nNOTE: STOP ALL servers and clients first\nContinue? (y/n): ", (Object[])new Object[0]);
            String inputString = scanner.nextLine();
            if (inputString.equals("y")) {
                DeleteLocalDatabaseDirs op = new DeleteLocalDatabaseDirs();
                op.run();
            }
        }
    }
}

