/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.pattern;

import org.eclipse.emf.common.util.EList;
import org.eclipse.graphiti.mm.Property;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.pattern.AbstractPattern;
import org.eclipse.graphiti.pattern.config.IPatternConfiguration;
import org.eclipse.graphiti.services.Graphiti;

public abstract class TypedPattern
extends AbstractPattern {
    protected static final String PROPERTY_KEY_PATTERN_TYPE = "org.eclipse.graphiti.pattern.patternType";

    public TypedPattern() {
    }

    public TypedPattern(IPatternConfiguration patternConfiguration) {
        super(patternConfiguration);
    }

    protected void setPatternType(PropertyContainer patternRootShape, String patternType) {
        Graphiti.getPeService().setPropertyValue(patternRootShape, PROPERTY_KEY_PATTERN_TYPE, patternType);
    }

    protected String getPatternType(PropertyContainer patternRootShape) {
        EList properties = patternRootShape.getProperties();
        for (Property property : properties) {
            if (!PROPERTY_KEY_PATTERN_TYPE.equals(property.getKey())) continue;
            return property.getValue();
        }
        if (patternRootShape instanceof Shape) {
            ContainerShape parent = ((Shape)patternRootShape).getContainer();
            if (parent != null && !(parent instanceof Diagram)) {
                return this.getPatternType((PropertyContainer)parent);
            }
        } else if (patternRootShape instanceof GraphicsAlgorithm) {
            PictogramElement pictogramElement = ((GraphicsAlgorithm)patternRootShape).getPictogramElement();
            if (pictogramElement != null) {
                return this.getPatternType((PropertyContainer)pictogramElement);
            }
            GraphicsAlgorithm parentGraphicsAlgorithm = ((GraphicsAlgorithm)patternRootShape).getParentGraphicsAlgorithm();
            if (parentGraphicsAlgorithm != null) {
                return this.getPatternType((PropertyContainer)parentGraphicsAlgorithm);
            }
        }
        return null;
    }
}

