/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.participants;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;

public class ResourceProcessors {
    public static String[] computeAffectedNatures(IResource resource) throws CoreException {
        IProject project = resource.getProject();
        HashSet<String> result = new HashSet<String>();
        HashSet<IProject> visitedProjects = new HashSet<IProject>();
        ResourceProcessors.computeNatures(result, visitedProjects, project);
        return result.toArray(new String[result.size()]);
    }

    public static String[] computeAffectedNatures(IResource[] resources) throws CoreException {
        HashSet<String> result = new HashSet<String>();
        HashSet<IProject> visitedProjects = new HashSet<IProject>();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            ResourceProcessors.computeNatures(result, visitedProjects, resource.getProject());
            ++n2;
        }
        return result.toArray(new String[result.size()]);
    }

    private static void computeNatures(Set<String> result, Set<IProject> visitedProjects, IProject focus) throws CoreException {
        if (visitedProjects.contains(focus)) {
            return;
        }
        String[] pns = focus.getDescription().getNatureIds();
        result.addAll(Arrays.asList(pns));
        visitedProjects.add(focus);
        IProject[] iProjectArray = focus.getReferencingProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject element = iProjectArray[n2];
            ResourceProcessors.computeNatures(result, visitedProjects, element);
            ++n2;
        }
    }

    private ResourceProcessors() {
    }
}

