/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ChecksumUtil {
    public static final String MD5 = "MD5";
    public static final String SHA = "SHA";
    private static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private ChecksumUtil() {
    }

    private static String getHexString(byte[] rawData) throws UnsupportedEncodingException {
        byte[] hex = new byte[2 * rawData.length];
        int index = 0;
        byte[] byArray = rawData;
        int n = rawData.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            int v = b & 0xFF;
            hex[index++] = HEX_CHAR_TABLE[v >>> 4];
            hex[index++] = HEX_CHAR_TABLE[v & 0xF];
            ++n2;
        }
        return new String(hex, "ASCII");
    }

    public static String createChecksumAsString(InputStream inputStream, String algorithm) throws Exception {
        return ChecksumUtil.getHexString(ChecksumUtil.createChecksum(inputStream, algorithm));
    }

    public static byte[] createChecksum(InputStream inputStream, String algorithm) throws IOException, NoSuchAlgorithmException {
        MessageDigest checksum = MessageDigest.getInstance(algorithm);
        byte[] buffer = new byte[1024];
        int numRead = -1;
        while ((numRead = inputStream.read(buffer)) != -1) {
            checksum.update(buffer, 0, numRead);
        }
        return checksum.digest();
    }
}

