/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.internal.PlatformTypeAccessor;
import org.eclipse.osee.mim.types.InterfaceEnumerationSet;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class InterfacePlatformTypeApiImpl
implements InterfacePlatformTypeApi {
    private ArtifactAccessor<PlatformTypeToken> accessor;

    InterfacePlatformTypeApiImpl(OrcsApi orcsApi) {
        this.setAccessor(new PlatformTypeAccessor(orcsApi));
    }

    @Override
    public ArtifactAccessor<PlatformTypeToken> getAccessor() {
        return this.accessor;
    }

    private void setAccessor(ArtifactAccessor<PlatformTypeToken> accessor) {
        this.accessor = accessor;
    }

    @Override
    public Collection<PlatformTypeToken> query(BranchId branch, MimAttributeQuery query) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<PlatformTypeToken>();
        }
    }

    @Override
    public PlatformTypeToken get(BranchId branch, ArtifactId platformTypeId) {
        try {
            return this.getAccessor().get(branch, platformTypeId, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithElementRelations(BranchId branch, ArtifactId platformTypeId) {
        try {
            return this.getAccessor().get(branch, platformTypeId, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element), PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithRelations(BranchId branch, ArtifactId platformTypeId, List<RelationTypeSide> relationTypes) {
        try {
            return this.getAccessor().get(branch, platformTypeId, relationTypes, PlatformTypeToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return PlatformTypeToken.SENTINEL;
        }
    }

    @Override
    public PlatformTypeToken getWithAllParentRelations(BranchId branch, ArtifactId platformTypeId) {
        List<RelationTypeSide> relations = Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element, CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionContent_Connection);
        return this.getWithRelations(branch, platformTypeId, relations);
    }

    @Override
    public List<PlatformTypeToken> getAllFromEnumerationSet(InterfaceEnumerationSet enumSet) {
        return enumSet.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfacePlatformTypeEnumeration_Element).stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new PlatformTypeToken((ArtifactReadable)a)).collect(Collectors.toList());
    }
}

