/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.osee.synchronization.util.HierarchyTreeNode;

public class HierarchyTree<K, V> {
    Map<K, HierarchyTreeNode<K, V>> nodeMap = new HashMap<K, HierarchyTreeNode<K, V>>();
    HierarchyTreeNode<K, V> rootNode = null;
    HierarchyTreeNode<K, V> currNode = null;

    public boolean containsKey(K key) {
        assert (Objects.nonNull(key));
        return this.nodeMap.containsKey(key);
    }

    public V get(K key) {
        assert (Objects.nonNull(key));
        HierarchyTreeNode<K, V> hierarchyTreeNode = this.nodeMap.get(key);
        if (hierarchyTreeNode == null) {
            return null;
        }
        return hierarchyTreeNode.getValue();
    }

    public void setCurrent(K key) {
        assert (Objects.nonNull(key));
        HierarchyTreeNode<K, V> hierarchyTreeNode = this.nodeMap.get(key);
        if (hierarchyTreeNode == null) {
            throw new RuntimeException("HierarchyTree::setCurrent: Node not found.");
        }
        this.currNode = hierarchyTreeNode;
        hierarchyTreeNode.setCurrent();
    }

    public void forEachChildKey(Consumer<? super K> action) {
        this.currNode.iteratorKeys().forEachRemaining(action);
    }

    public void forEachChildValue(Consumer<? super V> action) {
        this.currNode.iteratorValues().forEachRemaining(action);
    }

    public void put(K key, HierarchyTreeNode<K, V> node) {
        this.nodeMap.put(key, node);
    }

    public void setRoot(K key, V value) {
        if (this.rootNode != null) {
            throw new RuntimeException("Root node is already set");
        }
        HierarchyTreeNode<K, V> rootNode = new HierarchyTreeNode<K, V>(this, key, value);
        this.rootNode = rootNode;
        this.nodeMap.put(key, rootNode);
    }

    public void insertFirst(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            throw new RuntimeException("Parent node not found");
        }
        parent.insertFirst(key, value);
    }

    public void insertLast(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parentNode = this.nodeMap.get(parentKey);
        if (parentNode == null) {
            throw new RuntimeException("Parent node not found");
        }
        parentNode.insertLast(key, value);
    }

    public void insertBefore(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            throw new RuntimeException("Parent node not found");
        }
        parent.insertBefore(key, value);
    }

    public void insertAfter(K parentKey, K key, V value) {
        HierarchyTreeNode<K, V> parent = this.nodeMap.get(parentKey);
        if (parent == null) {
            throw new RuntimeException("Parent node not found");
        }
        parent.insertAfter(key, value);
    }

    public HierarchyTreeNode<K, V> root() {
        return this.rootNode;
    }

    public HierarchyTreeNode<K, V> getAssertNotNull(K key) {
        HierarchyTreeNode<K, V> node = this.nodeMap.get(key);
        if (node == null) {
            throw new RuntimeException("Node not found");
        }
        return node;
    }

    public HierarchyTreeNode<K, V> getFirstChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getFirstChild();
    }

    public HierarchyTreeNode<K, V> getLastChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getLastChild();
    }

    public HierarchyTreeNode<K, V> getCurrentChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getCurrentChild();
    }

    public HierarchyTreeNode<K, V> getPreviousChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getPreviousChild();
    }

    public HierarchyTreeNode<K, V> getNextChild(K parentKey) {
        return this.getAssertNotNull(parentKey).getNextChild();
    }

    public Iterator<HierarchyTreeNode<K, V>> iterator() {
        this.currNode = this.rootNode;
        return new Iterator<HierarchyTreeNode<K, V>>(){

            @Override
            public boolean hasNext() {
                return HierarchyTree.this.currNode.hasChildren() ? true : (HierarchyTree.this.currNode.hasNext() ? true : HierarchyTree.this.currNode.getParent().hasNext());
            }

            @Override
            public HierarchyTreeNode<K, V> next() {
                HierarchyTree.this.currNode = HierarchyTree.this.currNode.hasChildren() ? HierarchyTree.this.currNode.getFirstChild() : (HierarchyTree.this.currNode.hasNext() ? HierarchyTree.this.currNode.getNext() : HierarchyTree.this.currNode.getParent().getNext());
                return HierarchyTree.this.currNode;
            }
        };
    }

    public void forEach(BiConsumer<K, K> biConsumer) {
        this.iterator().forEachRemaining(hierarchyTreeNode -> {
            HierarchyTreeNode parent = hierarchyTreeNode.getParent();
            Object parentKey = parent != null ? (Object)parent.getKey() : null;
            Object key = hierarchyTreeNode.getKey();
            biConsumer.accept(parentKey, key);
        });
    }

    public Spliterator<HierarchyTreeNode<K, V>> spliterator() {
        this.currNode = this.rootNode;
        return new Spliterator<HierarchyTreeNode<K, V>>(){
            int index = 0;
            int size;
            {
                this.size = HierarchyTree.this.nodeMap.size();
            }

            @Override
            public int characteristics() {
                return 272;
            }

            @Override
            public long estimateSize() {
                return this.size - this.index;
            }

            @Override
            public boolean tryAdvance(Consumer<? super HierarchyTreeNode<K, V>> action) {
                HierarchyTreeNode nextNode = HierarchyTree.this.currNode.getFirstChild();
                if (nextNode == null) {
                    nextNode = HierarchyTree.this.currNode.getNext();
                }
                if (nextNode == null) {
                    return false;
                }
                action.accept(nextNode);
                ++this.index;
                HierarchyTree.this.currNode = nextNode;
                return true;
            }

            @Override
            public Spliterator<HierarchyTreeNode<K, V>> trySplit() {
                return null;
            }
        };
    }

    public Stream<V> stream() {
        return this.nodeMap.values().stream().map(HierarchyTreeNode::getValue);
    }

    public Stream<K> streamChildKeys() {
        return this.currNode.streamChildKeys();
    }
}

