/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.sql.join;

import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.logger.Log;

public class JoinCleanerCallable
implements Runnable {
    private static final String DELETE_JOIN_CLEANUP = "DELETE FROM osee_join_cleanup WHERE query_id = ?";
    private static final String SELECT_FROM_JOIN_CLEANUP = "SELECT * from osee_join_cleanup order by table_name";
    private final Log logger;
    private final JdbcClient jdbcClient;
    private String previousTableName;
    private long currentTime;
    private OseePreparedStatement joinDelete;
    private OseePreparedStatement cleanupDelete;

    public JoinCleanerCallable(Log logger, JdbcClient jdbcClient) {
        this.logger = logger;
        this.jdbcClient = jdbcClient;
    }

    private boolean isExpired(long issuedAt, long lifetime, long currentTime) {
        return lifetime != -1L && issuedAt + lifetime < currentTime;
    }

    private void resetForNextCall() {
        this.previousTableName = "";
        this.currentTime = System.currentTimeMillis() / 1000L;
        this.joinDelete = null;
        this.cleanupDelete = this.jdbcClient.getBatchStatement(DELETE_JOIN_CLEANUP);
    }

    @Override
    public void run() {
        try {
            this.resetForNextCall();
            try {
                this.jdbcClient.runQuery(this::processRow, SELECT_FROM_JOIN_CLEANUP, new Object[0]);
            }
            finally {
                this.cleanupDelete.execute();
                if (this.joinDelete != null) {
                    this.joinDelete.execute();
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Throwable)ex, "Error cleaning join tables", new Object[0]);
        }
    }

    private void processRow(JdbcStatement stmt) {
        long expiresIn;
        long issuedAt = stmt.getLong("issued_at");
        if (this.isExpired(issuedAt, expiresIn = stmt.getLong("expires_in"), this.currentTime)) {
            String tableName = stmt.getString("table_name");
            if (!tableName.equals(this.previousTableName)) {
                if (this.joinDelete != null) {
                    this.joinDelete.execute();
                }
                this.joinDelete = this.jdbcClient.getBatchStatement("DELETE FROM " + tableName + " WHERE query_id = ?");
                this.previousTableName = tableName;
            }
            Long queryId = stmt.getLong("query_id");
            this.joinDelete.addToBatch((Object)queryId);
            this.cleanupDelete.addToBatch((Object)queryId);
        }
    }
}

