/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.util.Objects;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.synchronization.util.IndentedString;
import org.eclipse.osee.synchronization.util.ToMessage;

class Root
implements ToMessage {
    private final BranchId branchId;
    private final ArtifactId artifactId;

    Root(BranchId branchId, ArtifactId artifactId) {
        assert (Objects.nonNull(branchId) && Objects.nonNull(artifactId));
        this.branchId = branchId;
        this.artifactId = artifactId;
    }

    Root(String branchIdString, String artifactIdString) {
        assert (Objects.nonNull(branchIdString) && Objects.nonNull(artifactIdString));
        this.branchId = BranchId.valueOf((Long)Long.parseUnsignedLong(branchIdString, 10));
        this.artifactId = ArtifactId.valueOf((Long)Long.parseUnsignedLong(artifactIdString, 10));
    }

    BranchId getBranchId() {
        return this.branchId;
    }

    ArtifactId getArtifactId() {
        return this.artifactId;
    }

    StringBuilder toText(StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(256);
        outMessage.append("BranchId( ").append(this.branchId).append(" ) ").append("ArtifactId( ").append(this.artifactId).append(" )");
        return outMessage;
    }

    @Override
    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString(indent + 0);
        String indent1 = IndentedString.indentString(indent + 1);
        outMessage.append(indent0).append("SpecificationGroveThing Root:").append("\n").append(indent1).append("Branch Identifier:   ").append(this.branchId).append("\n").append(indent1).append("Artifact Identifier: ").append(this.artifactId).append("\n");
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }
}

