/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin;

import java.util.Map;

public class AccountConfiguration {
    public static final String NAMESPACE = "account";
    public static final String HTTP_HEADER_NAME = AccountConfiguration.qualify("http.header.name");
    private String httpHeaderName;

    private AccountConfiguration() {
    }

    private static String qualify(String value) {
        return String.format("%s.%s", NAMESPACE, value);
    }

    public String getHttpHeaderName() {
        return this.httpHeaderName;
    }

    public void setHttpHeaderName(String httpHeaderName) {
        this.httpHeaderName = httpHeaderName;
    }

    public AccountConfiguration copy() {
        AccountConfiguration data = new AccountConfiguration();
        data.httpHeaderName = this.httpHeaderName;
        return data;
    }

    public static AccountConfigurationBuilder newBuilder() {
        return new AccountConfigurationBuilder();
    }

    public static AccountConfigurationBuilder fromProperties(Map<String, Object> props) {
        return AccountConfiguration.newBuilder().properties(props);
    }

    public static AccountConfiguration newConfig(Map<String, Object> props) {
        return AccountConfiguration.fromProperties(props).build();
    }

    public static final class AccountConfigurationBuilder {
        private final AccountConfiguration config = new AccountConfiguration();

        public AccountConfiguration build() {
            return this.config.copy();
        }

        public AccountConfigurationBuilder properties(Map<String, Object> props) {
            this.httpHeaderName(AccountConfigurationBuilder.get(props, HTTP_HEADER_NAME, ""));
            return this;
        }

        public AccountConfigurationBuilder httpHeaderName(String httpHeaderName) {
            this.config.setHttpHeaderName(httpHeaderName);
            return this;
        }

        private static String get(Map<String, Object> props, String key, String defaultValue) {
            Object object;
            String toReturn = defaultValue;
            Object object2 = object = props != null ? props.get(key) : null;
            if (object != null) {
                toReturn = String.valueOf(object);
            }
            return toReturn;
        }
    }
}

