/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.UserId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceMessageFilterEndpoint;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceNode;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;

public class InterfaceMessageFilterEndpointImpl
implements InterfaceMessageFilterEndpoint {
    private final BranchId branch;
    private final UserId account;
    private final ArtifactId ConnectionId;
    private final InterfaceMessageApi messageApi;
    private final InterfaceSubMessageApi subMessageApi;
    private final InterfaceNodeViewApi interfaceNodeApi;

    public InterfaceMessageFilterEndpointImpl(BranchId branch, ArtifactId connectionId, UserId account, InterfaceMessageApi interfaceMessageApi, InterfaceSubMessageApi interfaceSubMessageApi, InterfaceNodeViewApi interfaceNodeApi) {
        this.account = account;
        this.branch = branch;
        this.messageApi = interfaceMessageApi;
        this.subMessageApi = interfaceSubMessageApi;
        this.ConnectionId = connectionId;
        this.interfaceNodeApi = interfaceNodeApi;
    }

    @Override
    public Collection<InterfaceMessageToken> getMessages() {
        List messageList = (List)this.messageApi.getAllForConnection(this.branch, this.ConnectionId);
        return messageList;
    }

    private List<AttributeTypeId> createMessageAttributes() {
        LinkedList<AttributeTypeId> messageAttributes = new LinkedList<AttributeTypeId>();
        messageAttributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        messageAttributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        messageAttributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageNumber);
        messageAttributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessagePeriodicity);
        messageAttributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageRate);
        messageAttributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageWriteAccess);
        messageAttributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageType);
        return messageAttributes;
    }

    private List<AttributeTypeId> createSubmessageAttributes() {
        LinkedList<AttributeTypeId> subMessageAttributes = new LinkedList<AttributeTypeId>();
        subMessageAttributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        subMessageAttributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        subMessageAttributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceSubMessageNumber);
        return subMessageAttributes;
    }

    private List<AttributeTypeId> createNodeAttributes() {
        return Arrays.asList(CoreAttributeTypes.Name);
    }

    @Override
    public Collection<InterfaceMessageToken> getMessages(String filter) {
        List<AttributeTypeId> messageAttributes = this.createMessageAttributes();
        List<AttributeTypeId> subMessageAttributes = this.createSubmessageAttributes();
        List<AttributeTypeId> nodeAttributes = this.createNodeAttributes();
        try {
            List messageList = (List)this.messageApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceConnectionContent_Connection, this.ConnectionId, filter, messageAttributes, InterfaceMessageToken.class);
            for (InterfaceMessageToken message : messageList) {
                message.setSubMessages((List)this.subMessageApi.getAllByRelation(this.branch, ArtifactId.valueOf((Long)message.getId())));
                message.setInitiatingNode(this.interfaceNodeApi.getNodeForMessage(this.branch, ArtifactId.valueOf((Long)message.getId())));
            }
            LinkedList<InterfaceNode> nodes = new LinkedList<InterfaceNode>();
            nodes.addAll(this.interfaceNodeApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceConnectionPrimary_Connection, this.ConnectionId, filter, nodeAttributes, InterfaceNode.class));
            nodes.addAll(this.interfaceNodeApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceConnectionSecondary_Connection, this.ConnectionId, filter, nodeAttributes, InterfaceNode.class));
            for (InterfaceNode node : nodes) {
                List alternateMessageList = (List)this.messageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSendingNode_Node, ArtifactId.valueOf((Long)node.getId()), InterfaceMessageToken.class);
                for (InterfaceMessageToken alternateMessage : alternateMessageList) {
                    if (messageList.contains((Object)alternateMessage)) continue;
                    alternateMessage.setSubMessages((List)this.subMessageApi.getAllByRelation(this.branch, ArtifactId.valueOf((Long)alternateMessage.getId())));
                    alternateMessage.setInitiatingNode(node);
                    messageList.add(alternateMessage);
                }
            }
            List subMessages = (List)this.subMessageApi.getAllByFilter(this.branch, filter);
            for (InterfaceSubMessageToken subMessage : subMessages) {
                List alternateMessageList = (List)this.messageApi.getAccessor().getAllByRelation(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage, ArtifactId.valueOf((Long)subMessage.getId()), InterfaceMessageToken.class);
                for (InterfaceMessageToken alternateMessage : alternateMessageList) {
                    if (messageList.contains((Object)alternateMessage)) continue;
                    alternateMessage.setSubMessages((List)this.subMessageApi.getAccessor().getAllByRelationAndFilter(this.branch, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, ArtifactId.valueOf((Long)alternateMessage.getId()), filter, subMessageAttributes, InterfaceSubMessageToken.class));
                    alternateMessage.setInitiatingNode(this.interfaceNodeApi.getAccessor().getByRelationWithoutId(this.branch, CoreRelationTypes.InterfaceMessageSendingNode_Message, ArtifactId.valueOf((Long)alternateMessage.getId()), InterfaceNode.class));
                    messageList.add(alternateMessage);
                }
            }
            return messageList;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }
}

