/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceMessageApi;
import org.eclipse.osee.mim.InterfaceNodeViewApi;
import org.eclipse.osee.mim.InterfaceSubMessageApi;
import org.eclipse.osee.mim.internal.InterfaceMessageAccessor;
import org.eclipse.osee.mim.types.InterfaceMessageToken;
import org.eclipse.osee.mim.types.InterfaceSubMessageToken;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class InterfaceMessageApiImpl
implements InterfaceMessageApi {
    private ArtifactAccessor<InterfaceMessageToken> accessor;
    private final InterfaceSubMessageApi submessageApi;
    private final InterfaceNodeViewApi nodeApi;
    private final List<AttributeTypeId> messageAttributes;
    private final List<RelationTypeSide> relations;

    InterfaceMessageApiImpl(OrcsApi orcsApi, InterfaceNodeViewApi nodeApi, InterfaceSubMessageApi submessageApi) {
        this.submessageApi = submessageApi;
        this.nodeApi = nodeApi;
        this.setAccessor(new InterfaceMessageAccessor(orcsApi));
        this.messageAttributes = this.createMessageAttributes();
        this.relations = this.createRelationTypeSideList();
    }

    @Override
    public ArtifactAccessor<InterfaceMessageToken> getAccessor() {
        return this.accessor;
    }

    private void setAccessor(ArtifactAccessor<InterfaceMessageToken> accessor) {
        this.accessor = accessor;
    }

    private List<RelationTypeSide> createRelationTypeSideList() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceMessageSubMessageContent_SubMessage);
        return relations;
    }

    private List<AttributeTypeId> createMessageAttributes() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageNumber);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessagePeriodicity);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageRate);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageWriteAccess);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceMessageType);
        return attributes;
    }

    @Override
    public Collection<InterfaceMessageToken> query(BranchId branch, MimAttributeQuery query) {
        try {
            return this.getAccessor().getAllByQuery(branch, query, this.getFollowRelationDetails(), InterfaceMessageToken.class).stream().map(m -> this.setUpMessage(branch, (InterfaceMessageToken)((Object)m))).collect(Collectors.toList());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceMessageToken>();
        }
    }

    private InterfaceMessageToken setUpMessage(BranchId branch, InterfaceMessageToken message) {
        message.setInitiatingNode(this.nodeApi.getNodeForMessage(branch, ArtifactId.valueOf((Long)message.getId())));
        return message;
    }

    @Override
    public Collection<InterfaceMessageToken> getAll(BranchId branch) {
        try {
            return this.getAccessor().getAll(branch, this.getFollowRelationDetails(), InterfaceMessageToken.class).stream().map(m -> this.setUpMessage(branch, (InterfaceMessageToken)((Object)m))).collect(Collectors.toList());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceMessageToken>();
        }
    }

    @Override
    public Collection<InterfaceMessageToken> getAllForConnection(BranchId branch, ArtifactId connectionId) {
        try {
            return this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceConnectionContent_Connection, connectionId, this.getFollowRelationDetails(), InterfaceMessageToken.class).stream().map(m -> this.setUpMessage(branch, (InterfaceMessageToken)((Object)m))).collect(Collectors.toList());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex.getCause());
            return new LinkedList<InterfaceMessageToken>();
        }
    }

    @Override
    public InterfaceMessageToken getRelatedToConnection(BranchId branch, ArtifactId connectionId, ArtifactId messageId) {
        try {
            return this.setUpMessage(branch, this.getAccessor().getByRelation(branch, messageId, CoreRelationTypes.InterfaceConnectionContent_Connection, connectionId, this.getFollowRelationDetails(), InterfaceMessageToken.class));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceMessageToken.SENTINEL;
        }
    }

    @Override
    public List<RelationTypeSide> getFollowRelationDetails() {
        return this.relations;
    }

    @Override
    public InterfaceMessageToken get(BranchId branch, ArtifactId messageId) {
        try {
            return this.setUpMessage(branch, this.getAccessor().get(branch, messageId, this.getFollowRelationDetails(), InterfaceMessageToken.class));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceMessageToken.SENTINEL;
        }
    }

    @Override
    public List<InterfaceMessageToken> getAllRelatedFromSubMessage(InterfaceSubMessageToken subMessage) {
        return subMessage.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceMessageSubMessageContent_Message).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceMessageToken((ArtifactReadable)a)).collect(Collectors.toList());
    }

    @Override
    public InterfaceMessageToken getWithAllParentRelations(BranchId branch, ArtifactId messageId) {
        try {
            List<RelationTypeSide> parentRelations = Arrays.asList(CoreRelationTypes.InterfaceConnectionContent_Connection);
            return this.getAccessor().get(branch, messageId, parentRelations, InterfaceMessageToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceMessageToken.SENTINEL;
        }
    }
}

