/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.mim.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.mim.ArtifactAccessor;
import org.eclipse.osee.mim.InterfaceElementApi;
import org.eclipse.osee.mim.InterfacePlatformTypeApi;
import org.eclipse.osee.mim.internal.InterfaceElementAccessor;
import org.eclipse.osee.mim.types.InterfaceStructureElementToken;
import org.eclipse.osee.mim.types.MimAttributeQuery;
import org.eclipse.osee.mim.types.PlatformTypeToken;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class InterfaceElementApiImpl
implements InterfaceElementApi {
    private ArtifactAccessor<InterfaceStructureElementToken> accessor;
    private final InterfacePlatformTypeApi platformApi;
    private final List<AttributeTypeId> elementAttributeList;
    private final List<RelationTypeSide> relations;

    InterfaceElementApiImpl(OrcsApi orcsApi, InterfacePlatformTypeApi platformTypeApi) {
        this.setAccessor(new InterfaceElementAccessor(orcsApi));
        this.platformApi = platformTypeApi;
        this.elementAttributeList = this.createElementAttributeList();
        this.relations = this.createRelationTypeSideList();
    }

    private List<AttributeTypeId> createElementAttributeList() {
        LinkedList<AttributeTypeId> attributes = new LinkedList<AttributeTypeId>();
        attributes.add((AttributeTypeId)CoreAttributeTypes.Name);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Description);
        attributes.add((AttributeTypeId)CoreAttributeTypes.Notes);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementAlterable);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexEnd);
        attributes.add((AttributeTypeId)CoreAttributeTypes.InterfaceElementIndexStart);
        return attributes;
    }

    private List<RelationTypeSide> createRelationTypeSideList() {
        LinkedList<RelationTypeSide> relations = new LinkedList<RelationTypeSide>();
        relations.add(CoreRelationTypes.InterfaceElementPlatformType_PlatformType);
        return relations;
    }

    private ArtifactAccessor<InterfaceStructureElementToken> getAccessor() {
        return this.accessor;
    }

    public void setAccessor(ArtifactAccessor<InterfaceStructureElementToken> accessor) {
        this.accessor = accessor;
    }

    @Override
    public List<InterfaceStructureElementToken> getAll(BranchId branch) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAll(branch, InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelated(BranchId branch, ArtifactId structureId) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByRelation(branch, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, this.getFollowRelationDetails(), InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public InterfaceStructureElementToken getRelated(BranchId branch, ArtifactId structureId, ArtifactId elementId) {
        try {
            InterfaceStructureElementToken element = this.getAccessor().getByRelation(branch, elementId, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, this.getFollowRelationDetails(), InterfaceStructureElementToken.class);
            element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL);
            return element;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceStructureElementToken.SENTINEL;
        }
    }

    @Override
    public InterfaceStructureElementToken get(BranchId branch, ArtifactId elementId) {
        try {
            InterfaceStructureElementToken element = this.getAccessor().get(branch, elementId, this.getFollowRelationDetails(), InterfaceStructureElementToken.class);
            element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL);
            return element;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return null;
        }
    }

    private InterfaceStructureElementToken defaultSetUpElement(BranchId branch, InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement) {
        return this.defaultSetUpElement(branch, element, previousElement, PlatformTypeToken.SENTINEL);
    }

    private InterfaceStructureElementToken defaultSetUpElement(BranchId branch, InterfaceStructureElementToken element, InterfaceStructureElementToken previousElement, PlatformTypeToken defaultPlatformType) {
        try {
            PlatformTypeToken platformType;
            if (defaultPlatformType.isInvalid()) {
                ArtifactReadable platformTypeReadable = (ArtifactReadable)element.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceElementPlatformType_PlatformType).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
                platformType = new PlatformTypeToken(platformTypeReadable);
            } else {
                platformType = defaultPlatformType;
            }
            if (previousElement.isInvalid()) {
                element.setBeginByte(0.0);
                element.setBeginWord(0.0);
            } else {
                element.setBeginByte((previousElement.getEndByte() + 1.0) % 4.0);
                element.setBeginWord(Math.floor((previousElement.getEndWord() * 4.0 + previousElement.getEndByte() + 1.0) / 4.0));
            }
            element.setInterfacePlatformTypeBitSize(platformType.getInterfacePlatformTypeBitSize());
            element.setPlatformTypeId(platformType.getId());
            element.setPlatformTypeName(platformType.getName());
            element.setLogicalType(platformType.getInterfaceLogicalType() != null ? platformType.getInterfaceLogicalType() : "");
            element.setInterfacePlatformTypeMinval(platformType.getInterfacePlatformTypeMinval() != null ? platformType.getInterfacePlatformTypeMinval() : "");
            element.setInterfacePlatformTypeMaxval(platformType.getInterfacePlatformTypeMaxval() != null ? platformType.getInterfacePlatformTypeMaxval() : "");
            element.setInterfacePlatformTypeDefaultValue(platformType.getInterfacePlatformTypeDefaultValue() != null ? platformType.getInterfacePlatformTypeDefaultValue() : "");
            element.setUnits(platformType.getInterfacePlatformTypeUnits() != null ? platformType.getInterfacePlatformTypeUnits() : "");
            element.setInterfacePlatformTypeDescription(platformType.getDescription() != null ? platformType.getDescription() : "");
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        return element;
    }

    private List<InterfaceStructureElementToken> parseElements(BranchId branch, List<InterfaceStructureElementToken> elements) {
        return this.parseElements(branch, elements, PlatformTypeToken.SENTINEL);
    }

    private List<InterfaceStructureElementToken> parseElements(BranchId branch, List<InterfaceStructureElementToken> elements, PlatformTypeToken defaultPlatformType) {
        Iterator<InterfaceStructureElementToken> elementIterator = elements.iterator();
        LinkedList<InterfaceStructureElementToken> tempElements = new LinkedList<InterfaceStructureElementToken>();
        if (elements.size() >= 2) {
            InterfaceStructureElementToken previousElement = elementIterator.next();
            InterfaceStructureElementToken currentElement = elementIterator.next();
            this.defaultSetUpElement(branch, previousElement, InterfaceStructureElementToken.SENTINEL, previousElement.getPlatformType().isValid() ? previousElement.getPlatformType() : defaultPlatformType);
            tempElements.add(previousElement);
            if (!elementIterator.hasNext()) {
                currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, currentElement.getPlatformType().isValid() ? currentElement.getPlatformType() : defaultPlatformType);
            }
            while (elementIterator.hasNext()) {
                InterfaceStructureElementToken nextElement = elementIterator.next();
                currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, currentElement.getPlatformType().isValid() ? currentElement.getPlatformType() : defaultPlatformType);
                tempElements.add(currentElement);
                previousElement = currentElement;
                currentElement = nextElement;
            }
            currentElement = this.defaultSetUpElement(branch, currentElement, previousElement, currentElement.getPlatformType().isValid() ? currentElement.getPlatformType() : defaultPlatformType);
            tempElements.add(currentElement);
            elements = tempElements;
        } else {
            for (InterfaceStructureElementToken element : elements) {
                element = this.defaultSetUpElement(branch, element, InterfaceStructureElementToken.SENTINEL, element.getPlatformType().isValid() ? element.getPlatformType() : defaultPlatformType);
            }
        }
        return elements;
    }

    @Override
    public List<InterfaceStructureElementToken> getFiltered(BranchId branch, String filter) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByFilter(branch, filter, this.elementAttributeList, InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getElementsByType(BranchId branch, ArtifactId platformTypeId) {
        try {
            PlatformTypeToken platformType = this.platformApi.getWithRelations(branch, platformTypeId, Arrays.asList(CoreRelationTypes.InterfaceElementPlatformType_Element));
            List<InterfaceStructureElementToken> elements = platformType.getArtifactReadable().getRelatedList(CoreRelationTypes.InterfaceElementPlatformType_Element).stream().map(a -> new InterfaceStructureElementToken((ArtifactReadable)a)).collect(Collectors.toList());
            elements = this.parseElements(branch, elements, platformType);
            return elements;
        }
        catch (Exception ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllRelatedAndFilter(BranchId branch, ArtifactId structureId, String filter) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByRelationAndFilter(branch, CoreRelationTypes.InterfaceStructureContent_Structure, structureId, filter, this.elementAttributeList, this.getFollowRelationDetails(), InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public Collection<InterfaceStructureElementToken> query(BranchId branch, MimAttributeQuery query) {
        try {
            List<InterfaceStructureElementToken> elements = (List<InterfaceStructureElementToken>)this.getAccessor().getAllByQuery(branch, query, this.getFollowRelationDetails(), InterfaceStructureElementToken.class);
            elements = this.parseElements(branch, elements);
            return elements;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return new LinkedList<InterfaceStructureElementToken>();
        }
    }

    @Override
    public List<RelationTypeSide> getFollowRelationDetails() {
        return this.relations;
    }

    @Override
    public InterfaceStructureElementToken getWithAllParentRelations(BranchId branch, ArtifactId elementId) {
        try {
            List<RelationTypeSide> parentRelations = Arrays.asList(CoreRelationTypes.InterfaceStructureContent_Structure, CoreRelationTypes.InterfaceSubMessageContent_SubMessage, CoreRelationTypes.InterfaceMessageSubMessageContent_Message, CoreRelationTypes.InterfaceConnectionContent_Connection);
            return this.getAccessor().get(branch, elementId, parentRelations, InterfaceStructureElementToken.class);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            System.out.println(ex);
            return InterfaceStructureElementToken.SENTINEL;
        }
    }

    @Override
    public List<InterfaceStructureElementToken> getAllFromPlatformType(PlatformTypeToken pType) {
        return pType.getArtifactReadable().getRelated(CoreRelationTypes.InterfaceElementPlatformType_Element).getList().stream().filter(a -> !a.getExistingAttributeTypes().isEmpty()).map(a -> new InterfaceStructureElementToken((ArtifactReadable)a)).collect(Collectors.toList());
    }
}

