/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.util;

import java.util.AbstractSet;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.util.EnumFunctionalInterfaceMap;
import org.eclipse.osee.framework.jdk.core.util.EnumMapDuplicateEntryException;

public class AbstractEnumFunctionalInterfaceMap<K extends Enum<K>, F>
implements EnumFunctionalInterfaceMap<K, F> {
    EnumMap<K, F> enumMap;

    AbstractEnumFunctionalInterfaceMap(Class<K> enumerationKeyClass) {
        this.enumMap = new EnumMap<K, F>(enumerationKeyClass){
            private static final long serialVersionUID = 1L;

            @Override
            public Set<K> keySet() {
                final Set superKeySet = super.keySet();
                return new AbstractSet<K>(){

                    @Override
                    public Iterator<K> iterator() {
                        final Iterator rvIterator = superKeySet.iterator();
                        return new Iterator<K>(){

                            @Override
                            public boolean hasNext() {
                                return rvIterator.hasNext();
                            }

                            @Override
                            public K next() {
                                return (Enum)rvIterator.next();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return superKeySet.size();
                    }
                };
            }
        };
    }

    @Override
    public boolean containsKey(K key) {
        return this.enumMap.containsKey(Objects.requireNonNull(key));
    }

    @Override
    public Optional<F> getFunction(K key) {
        return Optional.ofNullable(this.enumMap.get(Objects.requireNonNull(key)));
    }

    @Override
    public boolean isEmpty() {
        return this.enumMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.enumMap.keySet();
    }

    protected AbstractEnumFunctionalInterfaceMap<K, F> ofEntriesLoader(Map.Entry<K, F>[] entries) {
        Map.Entry<K, F>[] entryArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Map.Entry<K, F> entry = entryArray[n2];
            Enum key = (Enum)entry.getKey();
            if (this.enumMap.containsKey(key)) {
                throw new EnumMapDuplicateEntryException(key);
            }
            this.enumMap.put(key, entry.getValue());
            ++n2;
        }
        return this;
    }

    @Override
    public void put(K key, F function) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(function);
        if (this.enumMap.containsKey(key)) {
            throw new EnumMapDuplicateEntryException(key);
        }
        this.enumMap.put(key, function);
    }

    @Override
    public int size() {
        return this.enumMap.size();
    }
}

