/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange.handler;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.osee.jdbc.SQL3DataType;

public class MetaData {
    private final Map<String, SQL3DataType> dataConversionMap = new LinkedHashMap<String, SQL3DataType>();
    private final String tableTarget;
    private String query;

    MetaData(String tableName) {
        this.tableTarget = tableName;
        this.query = null;
    }

    private String buildQuery() {
        String toReturn = null;
        Collection<String> columnNames = this.getColumnNames();
        if (!columnNames.isEmpty()) {
            String columns = columnNames.toString();
            columns = columns.substring(1, columns.length() - 1);
            StringBuffer params = new StringBuffer();
            int index = 0;
            while (index < columnNames.size()) {
                params.append("?");
                if (index + 1 < columnNames.size()) {
                    params.append(", ");
                }
                ++index;
            }
            toReturn = String.format("INSERT INTO %s (%s) VALUES (%s)", this.tableTarget, columns, params);
        }
        return toReturn;
    }

    void addColumn(String columnName, SQL3DataType sql3DataType) {
        this.dataConversionMap.put(columnName, sql3DataType);
    }

    public int getColumnSize() {
        return this.dataConversionMap.size();
    }

    public String getTableName() {
        return this.tableTarget;
    }

    public Collection<String> getColumnNames() {
        return this.dataConversionMap.keySet();
    }

    public String getQuery() {
        if (this.query == null) {
            this.query = this.buildQuery();
        }
        return this.query;
    }

    public SQL3DataType toDataType(String fieldName) {
        return this.dataConversionMap.get(fieldName);
    }

    public Class<?> toClass(String fieldName) {
        SQL3DataType dataType = this.dataConversionMap.get(fieldName);
        return dataType != null ? dataType.getJavaEquivalentClass() : null;
    }

    public String toString() {
        return this.getTableName();
    }
}

