/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.exchange;

import java.util.Map;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.db.internal.exchange.PrimaryKeyCollector;
import org.eclipse.osee.orcs.db.internal.exchange.handler.BaseDbSaxHandler;
import org.eclipse.osee.orcs.db.internal.exchange.handler.IExportItem;

public class ForeignKeyReader
extends BaseDbSaxHandler {
    private final String[] foreignKeys;
    private final PrimaryKeyCollector primaryKeyCollector;
    private final IExportItem foreignTable;

    public ForeignKeyReader(Log logger, JdbcClient jdbcClient, PrimaryKeyCollector primaryKeyCollector, IExportItem foreignTable, String ... foreignKeys) {
        super(logger, jdbcClient, true, 0);
        this.primaryKeyCollector = primaryKeyCollector;
        this.foreignKeys = foreignKeys;
        this.foreignTable = foreignTable;
    }

    @Override
    protected void processData(Map<String, String> fieldMap) {
        String[] stringArray = this.foreignKeys;
        int n = this.foreignKeys.length;
        int n2 = 0;
        while (n2 < n) {
            String foreignKey = stringArray[n2];
            String value = fieldMap.get(foreignKey);
            if (value != null) {
                Long id = Long.valueOf(value);
                this.primaryKeyCollector.markAsReferenced(this.foreignTable + "." + foreignKey, id);
            }
            ++n2;
        }
    }
}

