/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.db.internal.callable;

import java.util.Collection;
import org.eclipse.osee.console.admin.Console;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.OseePreparedStatement;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.db.internal.callable.AbstractDatastoreTxCallable;
import org.eclipse.osee.orcs.db.internal.sql.join.IdJoinQuery;
import org.eclipse.osee.orcs.db.internal.sql.join.SqlJoinFactory;

public final class PurgeAttributesDatabaseTxCallable
extends AbstractDatastoreTxCallable<Void> {
    private static final String SELECT_ATTRIBUTE_GAMMAS = "select gamma_id from osee_attribute, osee_join_id where attr_id = id and query_id = ?";
    private final SqlJoinFactory joinFactory;
    private final Collection<AttributeId> idsToPurge;
    private final Console console;

    public PurgeAttributesDatabaseTxCallable(Log logger, OrcsSession session, JdbcClient jdbcClient, SqlJoinFactory joinFactory, Collection<AttributeId> idsToPurge, Console console) {
        super(logger, session, jdbcClient);
        this.joinFactory = joinFactory;
        this.idsToPurge = idsToPurge;
        this.console = console;
    }

    @Override
    protected Void handleTxWork(JdbcConnection connection) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (IdJoinQuery idJoin = this.joinFactory.createIdJoinQuery(connection);){
            OseePreparedStatement attrBatch = this.getJdbcClient().getBatchStatement(connection, "delete from osee_attribute where attr_id = ?");
            OseePreparedStatement txBatch = this.getJdbcClient().getBatchStatement(connection, "delete from osee_txs where gamma_id = ?");
            for (AttributeId id : this.idsToPurge) {
                idJoin.add((Id)id);
                attrBatch.addToBatch((Object)id);
            }
            idJoin.store();
            this.getJdbcClient().runQuery(stmt -> txBatch.addToBatch((Object)stmt.getLong("gamma_id")), SELECT_ATTRIBUTE_GAMMAS, new Object[]{idJoin.getQueryId()});
            this.writeToConsole("Deleting gammas from osee_txs...");
            int deleted = txBatch.execute();
            this.writeToConsole(String.valueOf(deleted) + " rows deleted.");
            this.writeToConsole("Deleting attributes from osee_attribute...");
            deleted = attrBatch.execute();
            this.writeToConsole(String.valueOf(deleted) + " rows deleted.");
            this.writeToConsole("Operation Finished");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return null;
    }

    private void writeToConsole(String s) {
        if (this.console != null) {
            this.console.writeln((Object)s);
        }
    }
}

