/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.context;

import org.eclipse.osee.framework.core.access.AccessTypeMatch;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.access.context.AllowDeny;
import org.eclipse.osee.framework.core.access.context.IParentProvider;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;

public class RelationTypeAccessType
implements AccessType {
    private AllowDeny allowDeny;
    private RelationTypeToken relationType;
    private ArtifactTypeToken artifactType;

    public RelationTypeAccessType(AllowDeny allowDeny, RelationTypeToken relationType, ArtifactTypeToken artifactType) {
        this.allowDeny = allowDeny;
        this.relationType = relationType;
        this.artifactType = artifactType;
    }

    public AllowDeny getAllowDeny() {
        return this.allowDeny;
    }

    public void setAllowDeny(AllowDeny allowDeny) {
        this.allowDeny = allowDeny;
    }

    @Override
    public boolean isArtifactType() {
        return true;
    }

    public RelationTypeToken getRelationType() {
        return this.relationType;
    }

    public void setRelationType(RelationTypeToken relationType) {
        this.relationType = relationType;
    }

    public ArtifactTypeToken getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(ArtifactTypeToken artifactType) {
        this.artifactType = artifactType;
    }

    public String toString() {
        return "RelType [allow=" + (Object)((Object)this.allowDeny) + ", relType=" + this.relationType + ", artType=" + this.artifactType + "]";
    }

    @Override
    public AccessTypeMatch computeMatch(ArtifactToken otherArt, AttributeTypeToken attrType, RelationTypeToken relType, IParentProvider parentProvider) {
        if (otherArt.getArtifactType().inheritsFrom(this.artifactType) && relType.equals(this.relationType)) {
            if (this.allowDeny == AllowDeny.Allow) {
                return AccessTypeMatch.Allow;
            }
            if (this.allowDeny == AllowDeny.Deny) {
                return AccessTypeMatch.Deny;
            }
        }
        return AccessTypeMatch.NoMatch;
    }
}

