/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.Subscription;
import org.eclipse.osee.account.admin.SubscriptionGroup;
import org.eclipse.osee.account.admin.ds.SubscriptionStorage;
import org.eclipse.osee.account.rest.model.SubscriptionGroupId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.orcs.account.admin.internal.AbstractOrcsStorage;
import org.eclipse.osee.orcs.account.admin.internal.SubscriptionUtil;
import org.eclipse.osee.orcs.data.ArtifactReadable;
import org.eclipse.osee.orcs.transaction.TransactionBuilder;

public class OrcsSubscriptionStorage
extends AbstractOrcsStorage
implements SubscriptionStorage {
    public ResultSet<Subscription> getSubscriptionsByAccountId(ArtifactId accountId) {
        ResultSet accountResults = this.newQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andId(accountId).getResults();
        ArtifactReadable account = (ArtifactReadable)accountResults.getExactlyOne();
        ResultSet allGroups = this.newQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.SubscriptionGroup}).getResults();
        ArrayList<Subscription> subscriptions = new ArrayList<Subscription>();
        for (ArtifactReadable group : allGroups) {
            boolean related = account.areRelated(CoreRelationTypes.Users_Artifact, group);
            subscriptions.add(SubscriptionUtil.fromArtifactData(account, group, related));
        }
        return ResultSets.newResultSet(subscriptions);
    }

    public void updateSubscription(Subscription subscription, boolean activate) {
        ArtifactReadable account = this.newQuery().andId(subscription.getAccountId()).asArtifact();
        ArtifactReadable group = this.newQuery().andId((ArtifactId)subscription.getGroupId()).asArtifact();
        String txComment = String.format("%s user [%s] to [%s].", activate ? "Subscribe" : "Unsubscribe", account.getName(), group.getName());
        TransactionBuilder tx = this.newTransaction(txComment);
        if (activate) {
            tx.relate((ArtifactId)group, (RelationTypeToken)CoreRelationTypes.Users_Artifact, (ArtifactId)account);
        } else {
            tx.unrelate((ArtifactId)group, (RelationTypeToken)CoreRelationTypes.Users_Artifact, (ArtifactId)account);
        }
        tx.commit();
    }

    public Subscription getSubscriptionByEncodedId(String encodedId) {
        return SubscriptionUtil.fromEncodedUuid(encodedId, new LazyActiveDelegate());
    }

    public ResultSet<SubscriptionGroup> getSubscriptionGroups() {
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.SubscriptionGroup}).getResults();
        return this.getFactory().newAccountSubscriptionGroupResultSet((ResultSet<ArtifactReadable>)results);
    }

    public SubscriptionGroupId createSubscriptionGroup(String name) {
        String comment = String.format("Create subscription group [%s]", name);
        TransactionBuilder tx = this.newTransaction(comment);
        ArtifactToken artId = tx.createArtifact(CoreArtifactTypes.SubscriptionGroup, name);
        tx.commit();
        ArtifactReadable groupArt = (ArtifactReadable)this.newQuery().andId((ArtifactId)artId).getResults().getExactlyOne();
        return new SubscriptionGroupId(groupArt.getId());
    }

    public boolean deleteSubscriptionGroup(SubscriptionGroupId subscriptionId) {
        boolean toReturn = false;
        SubscriptionGroup subscriptionGroup = this.getSubscriptionGroupById(subscriptionId);
        if (subscriptionGroup != null) {
            ArtifactId subscriptionAsArtId = ArtifactId.create((Id)subscriptionId);
            String comment = String.format("Delete subscription group [%s]", subscriptionGroup.getName());
            TransactionBuilder tx = this.newTransaction(comment);
            tx.deleteArtifact(subscriptionAsArtId);
            tx.commit();
            toReturn = true;
        }
        return toReturn;
    }

    public SubscriptionGroup getSubscriptionGroupById(SubscriptionGroupId groupId) {
        ArtifactReadable artifact = this.newQuery().andId(ArtifactId.valueOf((Id)groupId)).getArtifact();
        return this.getFactory().newAccountSubscriptionGroup(artifact);
    }

    public boolean subscriptionGroupNameExists(String groupName) {
        return this.newQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.SubscriptionGroup}).andNameEquals(groupName).exists();
    }

    public ResultSet<Account> getSubscriptionMembersById(SubscriptionGroupId groupId) {
        ArtifactId groupArtId = ArtifactId.create((Id)groupId);
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.User}).andRelatedTo(CoreRelationTypes.Users_Artifact, groupArtId).getResults();
        return this.getFactory().newAccountResultSet((ResultSet<ArtifactReadable>)results);
    }

    public ResultSet<Account> getMembersOfSubscriptionGroupById(SubscriptionGroupId subscriptionId) {
        ResultSet results = this.newQuery().andTypeEquals(new ArtifactTypeToken[]{CoreArtifactTypes.SubscriptionGroup}).andUuid(subscriptionId.getId().longValue()).getResults();
        ArtifactReadable group = (ArtifactReadable)results.getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        return this.getMembers(group);
    }

    private ResultSet<Account> getMembers(ArtifactReadable group) {
        ResultSet<Account> toReturn = group.isValid() ? this.getFactory().newAccountResultSet((ResultSet<ArtifactReadable>)group.getRelated(CoreRelationTypes.Users_User)) : ResultSets.emptyResultSet();
        return toReturn;
    }

    private class LazyActiveDelegate
    implements SubscriptionUtil.ActiveDelegate {
        private final AtomicBoolean wasRun = new AtomicBoolean(false);
        private volatile boolean isActive;

        private LazyActiveDelegate() {
        }

        @Override
        public boolean isActive(ArtifactId accountId, SubscriptionGroupId groupId) {
            if (this.wasRun.compareAndSet(false, true)) {
                ArtifactReadable account = OrcsSubscriptionStorage.this.newQuery().andId(accountId).asArtifact();
                ArtifactReadable group = OrcsSubscriptionStorage.this.newQuery().andId((ArtifactId)groupId).asArtifact();
                this.isActive = account.areRelated(CoreRelationTypes.Users_Artifact, group);
            }
            return this.isActive;
        }
    }
}

