/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.synchronization.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.synchronization.rest.Root;
import org.eclipse.osee.synchronization.util.IndentedString;
import org.eclipse.osee.synchronization.util.ToMessage;

class RootList
implements Iterable<Root>,
ToMessage {
    private static final char specificationDelimiter = ';';
    private static final char branchDelimiter = ':';
    private static final char artifactDelimiter = ',';
    String synchronizationArtifactType;
    OrcsApi orcsApi;
    List<Root> rootsList;

    private static void splitter(char delimiter, String token, Consumer<String> sink) {
        String tokenPart;
        int tokenStartIndex = 0;
        int delimiterIndex = token.indexOf(delimiter);
        while (delimiterIndex >= 0) {
            tokenPart = token.substring(tokenStartIndex, delimiterIndex);
            sink.accept(tokenPart);
            tokenStartIndex = delimiterIndex + 1;
            delimiterIndex = token.indexOf(delimiter, delimiterIndex + 1);
        }
        tokenPart = token.substring(tokenStartIndex);
        sink.accept(tokenPart);
    }

    private RootList(OrcsApi orcsApi, String synchronizationArtifactType) {
        this.synchronizationArtifactType = synchronizationArtifactType;
        this.orcsApi = orcsApi;
        this.rootsList = new ArrayList<Root>();
    }

    private static boolean validateArtifactType(String token) {
        return token != null && !token.isEmpty();
    }

    private static boolean validateId(String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        int length = token.length();
        int i = 0;
        while (i < length) {
            CharacterType characterType = CharacterType.classifyCharacter(token.charAt(i));
            switch (characterType) {
                case DIGIT: {
                    break;
                }
                default: {
                    return false;
                }
            }
            ++i;
        }
        return true;
    }

    private static boolean validateRoots(String token) {
        if (token == null || token.isEmpty()) {
            return false;
        }
        int length = token.length();
        boolean requireDigit = true;
        boolean allowBranchDelimiter = true;
        boolean allowSpecificationDelimiter = false;
        boolean allowArtifactDelimiter = false;
        int i = 0;
        while (i < length) {
            CharacterType characterType = CharacterType.classifyCharacter(token.charAt(i));
            switch (characterType) {
                case ERROR: {
                    return false;
                }
                case DIGIT: {
                    requireDigit = false;
                    break;
                }
                case BRANCH_DELIMITER: {
                    if (requireDigit || allowArtifactDelimiter || allowSpecificationDelimiter) {
                        return false;
                    }
                    requireDigit = true;
                    allowBranchDelimiter = false;
                    allowSpecificationDelimiter = true;
                    allowArtifactDelimiter = true;
                    break;
                }
                case ARTIFACT_DELIMITER: {
                    if (requireDigit || allowBranchDelimiter) {
                        return false;
                    }
                    requireDigit = true;
                    allowBranchDelimiter = false;
                    allowSpecificationDelimiter = true;
                    allowArtifactDelimiter = true;
                    break;
                }
                case SPECIFICATION_DELIMITER: {
                    if (requireDigit || allowBranchDelimiter) {
                        return false;
                    }
                    requireDigit = true;
                    allowBranchDelimiter = true;
                    allowSpecificationDelimiter = false;
                    allowArtifactDelimiter = false;
                }
            }
            ++i;
        }
        return !requireDigit && !allowBranchDelimiter;
    }

    public static RootList create(OrcsApi orcsApi, String synchronizationArtifactType, BranchId branchId, ArtifactId artifactId) {
        boolean orcsApiValid = Objects.nonNull(orcsApi);
        boolean synchronizationArtifactTypeValid = RootList.validateArtifactType(synchronizationArtifactType);
        if (!orcsApiValid || !synchronizationArtifactTypeValid) {
            StringBuilder message = new StringBuilder(1024);
            if (!orcsApiValid) {
                message.append("INTERNAL ERROR: \"OrcsApi\" is null.").append("\n");
            }
            if (!synchronizationArtifactTypeValid) {
                message.append("ERROR: \"synchronizationArtifactType\" parameter is invalid.").append("\n").append("   synchronizationArtifactType: ").append(synchronizationArtifactType).append("\n ");
            }
            throw new RuntimeException(message.toString());
        }
        RootList rootList = new RootList(orcsApi, synchronizationArtifactType);
        Root root = new Root(branchId, artifactId);
        rootList.add(root);
        return rootList;
    }

    public static RootList create(OrcsApi orcsApi, String synchronizationArtifactType, String roots) {
        boolean orcsApiValid = Objects.nonNull(orcsApi);
        boolean rootsValid = RootList.validateRoots(roots);
        boolean artifactTypeValid = RootList.validateArtifactType(synchronizationArtifactType);
        if (!(orcsApiValid && rootsValid && artifactTypeValid)) {
            StringBuilder message = new StringBuilder(2048);
            if (!orcsApiValid) {
                message.append("INTERNAL ERROR: \"OrcsApi\" is null.").append("\n");
            }
            if (!rootsValid) {
                message.append("ERROR: \"roots\" parameter is invalid.").append("\n").append("   ").append("roots: ").append(roots).append("\n");
            }
            if (!artifactTypeValid) {
                message.append("ERROR: \"artifactType\" parameter is invalid.").append("\n").append("   artifactType: ").append(synchronizationArtifactType).append("\n ");
            }
            throw new RuntimeException(message.toString());
        }
        RootList rootList = new RootList(orcsApi, synchronizationArtifactType);
        RootList.splitter(';', roots, rootList::add);
        return rootList;
    }

    private void add(String token) {
        ArrayList tokens = new ArrayList(2);
        RootList.splitter(':', token, tokens::add);
        String branchId = (String)tokens.get(0);
        String artifactIdList = (String)tokens.get(1);
        RootList.splitter(',', artifactIdList, artifactId -> {
            boolean bl = this.rootsList.add(new Root(branchId, (String)artifactId));
        });
    }

    private void add(Root root) {
        this.rootsList.add(root);
    }

    public String getSynchronizationArtifactType() {
        return this.synchronizationArtifactType;
    }

    @Override
    public Iterator<Root> iterator() {
        return this.rootsList.iterator();
    }

    ListIterator<Root> listIterator() {
        return this.rootsList.listIterator();
    }

    public OrcsApi getOrcsApi() {
        return this.orcsApi;
    }

    public Stream<Root> stream() {
        return this.rootsList.stream();
    }

    StringBuilder toText(StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        boolean first = true;
        this.rootsList.stream().forEach(root -> {
            if (!first) {
                outMessage.append(", ");
            }
            root.toText(outMessage);
        });
        return outMessage;
    }

    @Override
    public StringBuilder toMessage(int indent, StringBuilder message) {
        StringBuilder outMessage = message != null ? message : new StringBuilder(1024);
        String indent0 = IndentedString.indentString(indent + 0);
        outMessage.append(indent0).append("Root List:").append("\n");
        this.rootsList.stream().forEach(root -> {
            StringBuilder stringBuilder2 = root.toMessage(indent + 1, outMessage);
        });
        return outMessage;
    }

    public String toString() {
        return this.toMessage(0, null).toString();
    }

    private static enum CharacterType {
        DIGIT,
        BRANCH_DELIMITER,
        ARTIFACT_DELIMITER,
        SPECIFICATION_DELIMITER,
        ERROR;


        public static CharacterType classifyCharacter(char character) {
            if (Character.isDigit(character)) {
                return DIGIT;
            }
            if (character == ':') {
                return BRANCH_DELIMITER;
            }
            if (character == ',') {
                return ARTIFACT_DELIMITER;
            }
            if (character == ';') {
                return SPECIFICATION_DELIMITER;
            }
            return ERROR;
        }
    }
}

