/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal;

import org.eclipse.osee.account.admin.Account;
import org.eclipse.osee.account.admin.AccountAdmin;
import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.account.admin.AccountPreferences;
import org.eclipse.osee.account.admin.internal.validator.Validator;
import org.eclipse.osee.framework.jdk.core.type.ResultSet;
import org.eclipse.osee.framework.jdk.core.type.ResultSets;
import org.eclipse.osee.framework.jdk.core.util.Conditions;

public class AccountResolver {
    private final Validator validator;
    private final AccountAdmin accountAdmin;

    public AccountResolver(Validator validator, AccountAdmin accountAdmin) {
        this.validator = validator;
        this.accountAdmin = accountAdmin;
    }

    public ResultSet<Account> resolveAccount(String uniqueFieldValue) {
        ResultSet<Account> toReturn;
        Conditions.checkNotNullOrEmpty((String)uniqueFieldValue, (String)"account unique field value");
        AccountField type = this.validator.guessFormatType(uniqueFieldValue);
        switch (type) {
            case EMAIL: {
                toReturn = this.accountAdmin.getAccountByEmail(uniqueFieldValue);
                break;
            }
            default: {
                toReturn = ResultSets.emptyResultSet();
            }
        }
        return toReturn;
    }

    public ResultSet<AccountPreferences> resolveAccountPreferences(String uniqueField) {
        ResultSet<Account> results = this.resolveAccount(uniqueField);
        return ResultSets.transform(results, source -> source.getPreferences());
    }
}

