/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.rs.security.oauth2.client.Consumer;
import org.apache.cxf.rs.security.oauth2.client.OAuthClientUtils;
import org.apache.cxf.rs.security.oauth2.common.AccessTokenValidation;
import org.apache.cxf.rs.security.oauth2.common.ClientAccessToken;
import org.apache.cxf.rs.security.oauth2.common.OAuthAuthorizationData;
import org.apache.cxf.rs.security.oauth2.common.OAuthPermission;
import org.apache.cxf.rs.security.oauth2.common.OOBAuthorizationResponse;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.UrlQuery;
import org.eclipse.osee.jaxrs.JaxRsConfirmAccessHandler;
import org.eclipse.osee.jaxrs.OAuth2Transport;
import org.eclipse.osee.jaxrs.OAuth2Util;

public class OAuth2Flows {
    private final OAuth2Transport transport;
    private final OwnerCredentials owner;
    private final Consumer client;
    private final String authorizeUri;
    private final String tokenUri;
    private final String tokenValidationUri;

    public OAuth2Flows(OAuth2Transport transport, OwnerCredentials owner, Consumer client, String authorizeUri, String tokenUri, String tokenValidationUri) {
        this.transport = transport;
        this.owner = owner;
        this.client = client;
        this.authorizeUri = authorizeUri;
        this.tokenUri = tokenUri;
        this.tokenValidationUri = tokenValidationUri;
    }

    public String generateState() {
        return OAuthUtils.generateRandomTokenKey();
    }

    public ClientAccessToken authorizationCodeFlow(JaxRsConfirmAccessHandler handler, String state, String scope, String redirectUri) {
        String sessionCookie = null;
        AuthFlowResponse response = this.requestAuthorizationGrant(state, scope, redirectUri);
        if (response.isAuthData()) {
            sessionCookie = response.getAuthenticityCookie();
            response = this.confirmAccess(handler, response.getAuthorizationData(), sessionCookie);
        }
        if (response.isOobAuthorization()) {
            String authorizationCode = response.getAuthorizationCode();
            if (!Strings.isValid((String)authorizationCode)) {
                throw OAuth2Util.newException("Authorization code was null", new Object[0]);
            }
            ClientAccessToken token = this.exchangeCodeForToken(sessionCookie, authorizationCode, state, scope, redirectUri);
            if (Strings.isValid((String)this.tokenValidationUri)) {
                this.validateToken(response.getAuthenticityCookie(), token);
            }
            return token;
        }
        throw OAuth2Util.newException("Auth flow is broken - invalid state", new Object[0]);
    }

    public ClientAccessToken refreshFlow(ClientAccessToken data, String state) {
        HashMap<String, String> extraParams = new HashMap<String, String>();
        if (data.getParameters() != null) {
            extraParams.putAll(data.getParameters());
        }
        extraParams.put("state", state);
        return this.transport.sendRefreshToken(this.owner, this.client, this.tokenUri, data.getRefreshToken(), data.getApprovedScope(), extraParams);
    }

    protected AuthFlowResponse requestAuthorizationGrant(String state, String scope, String redirectUri) {
        UriBuilder builder = OAuthClientUtils.getAuthorizationURIBuilder((String)this.authorizeUri, (String)this.client.getKey(), (String)scope);
        if (redirectUri != null) {
            builder.queryParam("redirect_uri", new Object[]{redirectUri});
        }
        if (state != null) {
            builder.queryParam("state", new Object[]{state});
        }
        builder.queryParam("client_secret", new Object[]{this.client.getSecret()});
        URI authorizationURI = builder.build(new Object[0]);
        Response response = this.transport.sendAuthorizationCodeRequest(this.owner, authorizationURI);
        Response.StatusType statusType = response.getStatusInfo();
        if (Response.Status.Family.SUCCESSFUL != statusType.getFamily()) {
            throw OAuth2Util.toException(response, "Error requesting authorization code");
        }
        OAuthAuthorizationData authData = null;
        try {
            response.bufferEntity();
            authData = (OAuthAuthorizationData)response.readEntity(OAuthAuthorizationData.class);
        }
        catch (Exception exception) {
            try {
                response.bufferEntity();
                OOBAuthorizationResponse oob = (OOBAuthorizationResponse)response.readEntity(OOBAuthorizationResponse.class);
                return new AuthFlowResponse(response, oob.getAuthorizationCode());
            }
            catch (Exception ex1) {
                throw OAuth2Util.newException(ex1, "Unexpected data type error [%s]", response.getEntity());
            }
        }
        OAuth2Flows.checkState(state, authData.getState());
        return new AuthFlowResponse(response, authData);
    }

    protected AuthFlowResponse confirmAccess(JaxRsConfirmAccessHandler handler, OAuthAuthorizationData authData, String sessionCookie) {
        JaxRsConfirmAccessHandler.ConfirmAccessRequest request = OAuth2Flows.newAccessConfirmRequest(authData);
        JaxRsConfirmAccessHandler.ConfirmAccessResponse ownerResponse = handler.onConfirmAccess(request);
        Form form = OAuth2Flows.newAccessConfirmForm(authData, ownerResponse);
        String replyTo = authData.getReplyTo();
        Response response = this.transport.sendAccessConfirmation(this.owner, sessionCookie, replyTo, form);
        Response.StatusType statusType = response.getStatusInfo();
        if (Response.Status.Family.SUCCESSFUL != statusType.getFamily() && Response.Status.Family.REDIRECTION != statusType.getFamily()) {
            throw OAuth2Util.toException(response, "Error requesting access confirmation");
        }
        String code = null;
        URI location = response.getLocation();
        if (location != null) {
            UrlQuery query = new UrlQuery();
            try {
                query.parse(location.getQuery());
                code = query.getParameter("code");
                OAuth2Flows.checkState(authData.getState(), query.getParameter("state"));
            }
            catch (UnsupportedEncodingException ex) {
                throw OAuth2Util.newException(ex, "Exception while parsing auth code URI [%s]", location);
            }
        }
        try {
            response.bufferEntity();
            OOBAuthorizationResponse oob = (OOBAuthorizationResponse)response.readEntity(OOBAuthorizationResponse.class);
            code = oob.getAuthorizationCode();
        }
        catch (Exception ex) {
            String value = (String)response.readEntity(String.class);
            throw OAuth2Util.newException(ex, "Unexpected data type error [%s]", value);
        }
        return new AuthFlowResponse(response, code);
    }

    protected ClientAccessToken exchangeCodeForToken(String sessionCookie, String authCode, String state, String scope, String redirectUri) {
        HashMap<String, String> extraParams = new HashMap<String, String>();
        if (state != null) {
            extraParams.put("state", state);
        }
        if (scope != null) {
            extraParams.put("scope", scope);
        }
        try {
            return this.transport.sendAuthorizationCodeGrant(this.owner, this.client, sessionCookie, this.tokenUri, authCode, redirectUri, extraParams);
        }
        catch (Exception ex) {
            throw OAuth2Util.newException(ex, "Error exchanging authorization grant for access token", new Object[0]);
        }
    }

    protected void validateToken(String sessionCookie, ClientAccessToken token) {
        Form form = new Form();
        form.param("authScheme", token.getTokenType());
        form.param("authSchemeData", token.getTokenKey());
        try {
            AccessTokenValidation validation = this.transport.sendTokenValidationRequest(this.owner, this.client, sessionCookie, this.tokenValidationUri, form);
            OAuth2Flows.assertTokenEquals(token, validation);
        }
        catch (Exception ex) {
            throw OAuth2Util.newException(ex, "Token validation failed", new Object[0]);
        }
    }

    private static void assertTokenEquals(ClientAccessToken expected, AccessTokenValidation actual) {
        if (!(OAuth2Flows.equals(expected.getTokenKey(), actual.getTokenKey()) && OAuth2Flows.equals(expected.getTokenType(), actual.getTokenType()) && OAuth2Flows.equals(expected.getExpiresIn(), actual.getTokenLifetime()) && OAuth2Flows.equals(expected.getIssuedAt(), actual.getTokenIssuedAt()))) {
            throw OAuth2Util.newException("Token validation failed", new Object[0]);
        }
    }

    private static void checkState(String expected, String actual) {
        if (!OAuth2Flows.equals(expected, actual)) {
            throw OAuth2Util.newException("OAuth Authorization Flow - Expected state [%s] did not match response state [%s]", expected, actual);
        }
    }

    private static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    protected static Form newAccessConfirmForm(OAuthAuthorizationData data, JaxRsConfirmAccessHandler.ConfirmAccessResponse ownerResponse) {
        Form form = new Form();
        form.param("client_id", data.getClientId());
        form.param("audience", data.getAudience());
        form.param("session_authenticity_token", data.getAuthenticityToken());
        form.param("redirect_uri", data.getRedirectUri());
        form.param("state", data.getState());
        form.param("scope", data.getProposedScope());
        List<? extends JaxRsConfirmAccessHandler.Permission> permissions = ownerResponse.getPermissionsGranted();
        if (permissions != null) {
            for (JaxRsConfirmAccessHandler.Permission permission : permissions) {
                String name = String.format("%s_status", permission.getName());
                form.param(name, "allow");
            }
        }
        form.param("oauthDecision", ownerResponse.isGranted() ? "allow" : "deny");
        return form;
    }

    protected static JaxRsConfirmAccessHandler.ConfirmAccessRequest newAccessConfirmRequest(OAuthAuthorizationData data) {
        return new ConfirmAccessRequestWrapper(data);
    }

    protected static JaxRsConfirmAccessHandler.Permission asPermission(OAuthPermission perm) {
        return new PermissionWrapper(perm);
    }

    protected static final class AuthFlowResponse {
        private final OAuthAuthorizationData authData;
        private final String authCode;
        private final Response response;
        private final boolean isAuthData;
        private final boolean isOobAuthorization;

        public AuthFlowResponse(Response response, OAuthAuthorizationData authData) {
            this.response = response;
            this.isAuthData = true;
            this.isOobAuthorization = false;
            this.authData = authData;
            this.authCode = null;
        }

        public AuthFlowResponse(Response response, String authCode) {
            this.response = response;
            this.authCode = authCode;
            this.isAuthData = false;
            this.isOobAuthorization = true;
            this.authData = null;
        }

        public String getAuthorizationCode() {
            return this.authCode;
        }

        public String getAuthenticityCookie() {
            return (String)this.response.getMetadata().getFirst((Object)"Set-Cookie");
        }

        public boolean isAuthData() {
            return this.isAuthData;
        }

        public boolean isOobAuthorization() {
            return this.isOobAuthorization;
        }

        public OAuthAuthorizationData getAuthorizationData() {
            return this.authData;
        }

        public <T> T getData(Class<T> clazz) {
            return (T)this.response.getEntity();
        }
    }

    private static final class ConfirmAccessRequestWrapper
    implements JaxRsConfirmAccessHandler.ConfirmAccessRequest {
        private final OAuthAuthorizationData data;
        private List<JaxRsConfirmAccessHandler.Permission> permissions;

        public ConfirmAccessRequestWrapper(OAuthAuthorizationData data) {
            this.data = data;
        }

        @Override
        public List<? extends JaxRsConfirmAccessHandler.Permission> getPermissionsRequested() {
            if (this.permissions == null) {
                ArrayList<JaxRsConfirmAccessHandler.Permission> permissions = new ArrayList<JaxRsConfirmAccessHandler.Permission>();
                for (OAuthPermission perm : this.data.getPermissions()) {
                    permissions.add(OAuth2Flows.asPermission(perm));
                }
                this.permissions = Collections.unmodifiableList(permissions);
            }
            return this.permissions;
        }

        @Override
        public String getEndUserName() {
            return this.data.getEndUserName();
        }

        @Override
        public String getApplicationWebUri() {
            return this.data.getApplicationWebUri();
        }

        @Override
        public String getApplicationName() {
            return this.data.getApplicationName();
        }

        @Override
        public String getApplicationLogoUri() {
            return this.data.getApplicationLogoUri();
        }

        @Override
        public String getApplicationDescription() {
            return this.data.getApplicationDescription();
        }

        public String toString() {
            return "ConfirmAccessRequest [data=" + this.data + "]";
        }
    }

    public static interface OwnerCredentials {
        public String getUsername();

        public String getPassword();
    }

    private static final class PermissionWrapper
    implements JaxRsConfirmAccessHandler.Permission {
        private final OAuthPermission perm;

        public PermissionWrapper(OAuthPermission perm) {
            this.perm = perm;
        }

        @Override
        public String getName() {
            return this.perm.getPermission();
        }

        @Override
        public String getDescription() {
            return this.perm.getDescription();
        }

        @Override
        public boolean isDefault() {
            return this.perm.isDefault();
        }

        public String toString() {
            return "Permission [name=" + this.getName() + ", description=" + this.getDescription() + ", isDefault=" + this.isDefault() + "]";
        }
    }
}

