/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.ext.RuntimeDelegate;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.configuration.security.ProxyAuthorizationPolicy;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.jaxrs.client.ThreadLocalClientState;
import org.apache.cxf.jaxrs.client.spec.ClientBuilderImpl;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.transport.common.gzip.GZIPFeature;
import org.apache.cxf.transport.http.HTTPConduit;
import org.apache.cxf.transports.http.configuration.ConnectionType;
import org.apache.cxf.transports.http.configuration.HTTPClientPolicy;
import org.apache.cxf.transports.http.configuration.ProxyServerType;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.UserService;
import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.jaxrs.GenericResponseExceptionMapper;
import org.eclipse.osee.jaxrs.JaxRsClientConfig;
import org.eclipse.osee.jaxrs.JaxRsClientConstants;
import org.eclipse.osee.jaxrs.OAuth2ClientRequestFilter;
import org.eclipse.osee.jaxrs.OAuth2Util;
import org.eclipse.osee.jaxrs.OrcsParamConverterProvider;
import org.eclipse.osee.jaxrs.OseeAccountClientRequestFilter;

public final class CxfJaxRsClientConfigurator {
    private static final String JAVAX_WS_RS_CLIENT_BUILDER_PROPERTY = "javax.ws.rs.client.ClientBuilder";
    private static final String DEFAULT_JAXRS_CLIENT_BUILDER_IMPL = "org.apache.cxf.jaxrs.client.spec.ClientBuilderImpl";
    private final OAuthFactory oauthFactory;
    private final List<Object> providers = new ArrayList<Object>();
    private final List<Feature> features = new ArrayList<Feature>(2);

    public CxfJaxRsClientConfigurator(OAuthFactory oauthFactory) {
        this.oauthFactory = oauthFactory;
    }

    public void configureJaxRsRuntime() {
        RuntimeDelegateImpl runtimeDelegate = new RuntimeDelegateImpl();
        RuntimeDelegate.setInstance((RuntimeDelegate)runtimeDelegate);
        new ClientBuilderImpl();
        System.setProperty(JAVAX_WS_RS_CLIENT_BUILDER_PROPERTY, DEFAULT_JAXRS_CLIENT_BUILDER_IMPL);
    }

    public void configureDefaults(ObjectMapper mapper, OrcsTokenService tokenService, UserService userService) {
        this.providers.add(new GenericResponseExceptionMapper());
        this.providers.add(new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS));
        this.providers.add(JsonParseExceptionMapper.class);
        this.providers.add(JsonMappingExceptionMapper.class);
        this.providers.addAll(OAuth2Util.getOAuthProviders());
        this.providers.add(new OrcsParamConverterProvider(tokenService));
        if (userService != null) {
            this.providers.add(new OseeAccountClientRequestFilter(userService));
        }
        this.features.add((Feature)new GZIPFeature());
    }

    public void configureBean(JaxRsClientConfig config, String serverAddress, JAXRSClientFactoryBean bean) {
        Conditions.checkNotNullOrEmpty((String)serverAddress, (String)"server address");
        bean.setAddress(serverAddress);
        bean.setProviders(this.providers);
        bean.setFeatures(this.features);
        bean.setProviders(this.getOAuthProviders(config));
        boolean threadSafe = config.isCreateThreadSafeProxyClients();
        if (threadSafe) {
            bean.setInitialState((ClientState)new ThreadLocalClientState(serverAddress));
        }
        boolean inheritHeaders = config.isProxyClientSubResourcesInheritHeaders();
        bean.setInheritHeaders(inheritHeaders);
    }

    public void configureClientBuilder(JaxRsClientConfig config, ClientBuilder builder) {
        this.register(builder, this.providers);
        this.register(builder, this.features);
        this.register(builder, this.getOAuthProviders(config));
    }

    public void configureConnection(JaxRsClientConfig config, HTTPConduit conduit) {
        HTTPClientPolicy policy1 = this.getClientPolicy(conduit);
        policy1.setAllowChunking(config.isChunkingAllowed());
        policy1.setAsyncExecuteTimeout(config.getAsyncExecuteTimeout());
        policy1.setAsyncExecuteTimeoutRejection(config.isAsyncExecuteTimeoutRejection());
        policy1.setAutoRedirect(config.isFollowRedirectsAllowed());
        policy1.setChunkingThreshold(config.getChunkingThreshold());
        policy1.setChunkLength(config.getChunkLength());
        policy1.setConnection(this.asCxfConnectionType(config.getConnectionType()));
        policy1.setConnectionTimeout(config.getConnectionTimeout());
        policy1.setMaxRetransmits(config.getMaxRetransmits());
        policy1.setReceiveTimeout(config.getReceiveTimeout());
        if (config.isServerAuthorizationRequired() && !this.isOAuthEnabled(config)) {
            AuthorizationPolicy policy2 = this.getAuthorizationPolicy(conduit);
            policy2.setUserName(config.getServerUsername());
            policy2.setPassword(config.getServerPassword());
            policy2.setAuthorizationType(config.getServerAuthorizationType());
        }
    }

    public void configureProxy(JaxRsClientConfig config, HTTPConduit conduit) {
        if (config.isProxyRequired()) {
            HTTPClientPolicy policy1 = this.getClientPolicy(conduit);
            policy1.setProxyServer(config.getProxyAddress());
            int proxyPort = config.getProxyPort();
            if (proxyPort > 0) {
                policy1.setProxyServerPort(Integer.valueOf(proxyPort));
            }
            policy1.setNonProxyHosts(config.getNonProxyHosts());
            policy1.setProxyServerType(this.asProxyServerType(config.getProxyType()));
            if (config.isProxyAuthorizationRequired()) {
                ProxyAuthorizationPolicy policy3 = this.getProxyAuthorizationPolicy(conduit);
                policy3.setUserName(config.getProxyUsername());
                policy3.setPassword(config.getProxyPassword());
                policy3.setAuthorizationType(config.getProxyAuthorizationType());
            }
        }
    }

    private List<Object> getOAuthProviders(JaxRsClientConfig config) {
        List<Object> providers = Collections.emptyList();
        if (this.isOAuthEnabled(config)) {
            OAuth2ClientRequestFilter filter = this.oauthFactory.newOAuthClientFilter(config.getServerUsername(), config.getServerPassword(), config.getOAuthClientId(), config.getOAuthClientSecret(), config.getOAuthAuthorizeUri(), config.getOAuthTokenUri(), config.getOAuthTokenValidationUri());
            if (config.isOAuthTokenCacheEnabled()) {
                int cacheMaxSize = config.getOAuthCacheMaxSize();
                long cacheEvictTimeoutMillis = config.getOAuthCacheEvictTimeoutMillis();
                OAuth2ClientRequestFilter.ClientAccessTokenCache cache = this.oauthFactory.newClientAccessTokenCache(cacheMaxSize, cacheEvictTimeoutMillis);
                filter.setClientAccessTokenCache(cache);
            }
            filter.setSecretKeyAlgorithm(config.getOAuthSecretKeyAlgorithm());
            filter.setSecretKeyEncoded(config.getOAuthEncodedSecretKey());
            filter.setFailOnRefreshTokenError(config.isOAuthFailsOnRefreshTokenError());
            filter.setRedirectUri(config.getOAuthRedirectUri());
            filter.setScopes(config.getOAuthScopes());
            filter.setTokenStore(config.getOAuthTokenStore());
            filter.setTokenHandler(config.getOAuthTokenHandler());
            providers = Collections.singletonList(filter);
        }
        return providers;
    }

    private boolean isOAuthEnabled(JaxRsClientConfig config) {
        String clientId = config.getOAuthClientId();
        return Strings.isValid((String)clientId);
    }

    private void register(ClientBuilder builder, Iterable<? extends Object> objects) {
        for (Object object : objects) {
            try {
                builder.register(object);
            }
            catch (Exception ex) {
                OseeLog.log(this.getClass(), (Level)Level.WARNING, (Throwable)ex);
            }
        }
    }

    private HTTPClientPolicy getClientPolicy(HTTPConduit conduit) {
        HTTPClientPolicy toReturn = conduit.getClient();
        if (toReturn == null) {
            toReturn = new HTTPClientPolicy();
            conduit.setClient(toReturn);
        }
        return toReturn;
    }

    private AuthorizationPolicy getAuthorizationPolicy(HTTPConduit conduit) {
        AuthorizationPolicy toReturn = conduit.getAuthorization();
        if (toReturn == null) {
            toReturn = new AuthorizationPolicy();
            conduit.setAuthorization(toReturn);
        }
        return toReturn;
    }

    private ProxyAuthorizationPolicy getProxyAuthorizationPolicy(HTTPConduit conduit) {
        ProxyAuthorizationPolicy toReturn = conduit.getProxyAuthorization();
        if (toReturn == null) {
            toReturn = new ProxyAuthorizationPolicy();
            conduit.setProxyAuthorization(toReturn);
        }
        return toReturn;
    }

    private ProxyServerType asProxyServerType(JaxRsClientConstants.ProxyType type) {
        ProxyServerType toReturn = ProxyServerType.HTTP;
        if (JaxRsClientConstants.ProxyType.SOCKS == type) {
            toReturn = ProxyServerType.SOCKS;
        }
        return toReturn;
    }

    private ConnectionType asCxfConnectionType(JaxRsClientConstants.ConnectionType type) {
        ConnectionType toReturn = ConnectionType.KEEP_ALIVE;
        if (JaxRsClientConstants.ConnectionType.CLOSE == type) {
            toReturn = ConnectionType.CLOSE;
        }
        return toReturn;
    }

    public static interface OAuthFactory {
        public OAuth2ClientRequestFilter newOAuthClientFilter(String var1, String var2, String var3, String var4, String var5, String var6, String var7);

        public OAuth2ClientRequestFilter.ClientAccessTokenCache newClientAccessTokenCache(int var1, long var2);
    }
}

