/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.artifact;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.AttributeDoesNotExist;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.orcs.OrcsSession;
import org.eclipse.osee.orcs.core.ds.ArtifactData;
import org.eclipse.osee.orcs.core.ds.ArtifactDataFactory;
import org.eclipse.osee.orcs.core.ds.Attribute;
import org.eclipse.osee.orcs.core.ds.AttributeData;
import org.eclipse.osee.orcs.core.internal.artifact.Artifact;
import org.eclipse.osee.orcs.core.internal.artifact.ArtifactImpl;
import org.eclipse.osee.orcs.core.internal.attribute.AttributeFactory;
import org.eclipse.osee.orcs.data.AttributeReadable;

public class ArtifactFactory {
    private final ArtifactDataFactory factory;
    private final AttributeFactory attributeFactory;

    public ArtifactFactory(ArtifactDataFactory factory, AttributeFactory attributeFactory) {
        this.factory = factory;
        this.attributeFactory = attributeFactory;
    }

    public Artifact createArtifact(OrcsSession session, ArtifactData artifactData) {
        return new ArtifactImpl(artifactData, this.attributeFactory);
    }

    public Artifact createArtifact(OrcsSession session, BranchId branch, ArtifactTypeToken artifactType, String guid) {
        ArtifactData artifactData = this.factory.create(branch, artifactType, guid);
        Artifact artifact = this.createArtifact(session, artifactData);
        artifact.setLoaded(true);
        return artifact;
    }

    public Artifact createArtifact(OrcsSession session, BranchId branch, ArtifactTypeToken artifactType, String guid, ApplicabilityId appId) {
        ArtifactData artifactData = this.factory.create(branch, artifactType, guid, appId);
        Artifact artifact = this.createArtifact(session, artifactData);
        artifact.setLoaded(true);
        return artifact;
    }

    public Artifact createArtifact(OrcsSession session, BranchId branch, ArtifactTypeToken artifactType, ArtifactId artifactId) {
        ArtifactData artifactData = this.factory.create(branch, artifactType, artifactId);
        Artifact artifact = this.createArtifact(session, artifactData);
        artifact.setLoaded(true);
        return artifact;
    }

    public Artifact createArtifact(OrcsSession session, BranchId branch, ArtifactTypeToken artifactType, ArtifactId artifactId, ApplicabilityId appId) {
        ArtifactData artifactData = this.factory.create(branch, artifactType, artifactId, appId);
        Artifact artifact = this.createArtifact(session, artifactData);
        artifact.setLoaded(true);
        return artifact;
    }

    public Artifact copyArtifact(OrcsSession session, Artifact source, Collection<AttributeTypeToken> types, BranchId ontoBranch) {
        ArtifactData artifactData = this.factory.copy(ontoBranch, (ArtifactData)source.getOrcsData());
        Artifact copy = this.createArtifact(session, artifactData);
        Collection<AttributeTypeToken> typesToCopy = this.getAllowedTypes(copy, types);
        for (AttributeTypeToken attributeType : typesToCopy) {
            for (AttributeReadable attributeReadable : source.getAttributes(attributeType)) {
                AttributeData data = this.getAttributeData(attributeReadable);
                this.attributeFactory.copyAttribute(data, ontoBranch, copy);
            }
        }
        copy.setLoaded(true);
        return copy;
    }

    public Artifact introduceArtifact(OrcsSession session, Artifact source, Artifact destination, BranchId ontoBranch) {
        destination = this.processIntroduceArtifact(session, source, destination, ontoBranch);
        this.processIntroduceAttributes(source, destination, ontoBranch);
        destination.setLoaded(true);
        return destination;
    }

    private void processIntroduceAttributes(Artifact source, Artifact destination, BranchId ontoBranch) {
        List introduceAttributes = source.getAttributes(DeletionFlag.INCLUDE_DELETED);
        this.removeAttributes(source, destination);
        for (Attribute attribute : introduceAttributes) {
            if (!destination.isAttributeTypeValid((AttributeTypeId)attribute.getAttributeType())) continue;
            this.attributeFactory.introduceAttribute((AttributeData)attribute.getOrcsData(), ontoBranch, destination);
        }
    }

    private Artifact processIntroduceArtifact(OrcsSession session, Artifact source, Artifact destination, BranchId ontoBranch) {
        ArtifactData artifactData = this.factory.introduce(ontoBranch, (ArtifactData)source.getOrcsData());
        destination.setOrcsData(artifactData);
        return destination;
    }

    private void removeAttributes(Artifact introduce, Artifact destination) {
        for (Attribute destAttribute : destination.getAttributes(DeletionFlag.INCLUDE_DELETED)) {
            try {
                introduce.getAttributeById((AttributeId)destAttribute);
            }
            catch (AttributeDoesNotExist attributeDoesNotExist) {
                destAttribute.delete();
            }
        }
    }

    public Artifact clone(OrcsSession session, Artifact source) {
        ArtifactData artifactData = this.factory.clone((ArtifactData)source.getOrcsData());
        Artifact copy = this.createArtifact(session, artifactData);
        for (AttributeTypeToken attributeType : source.getExistingAttributeTypes()) {
            for (AttributeReadable attributeReadable : source.getAttributes(attributeType)) {
                AttributeData data = this.getAttributeData(attributeReadable);
                this.attributeFactory.cloneAttribute(data, copy);
            }
        }
        copy.setLoaded(true);
        return copy;
    }

    private AttributeData getAttributeData(AttributeReadable<?> source) {
        return (AttributeData)((Attribute)source).getOrcsData();
    }

    private Collection<AttributeTypeToken> getAllowedTypes(Artifact destination, Collection<AttributeTypeToken> types) {
        HashSet<AttributeTypeToken> toReturn = new HashSet<AttributeTypeToken>();
        for (AttributeTypeToken type : types) {
            if (!type.notEqual((Id)CoreAttributeTypes.RelationOrder) || !destination.isAttributeTypeValid((AttributeTypeId)type)) continue;
            toReturn.add(type);
        }
        return toReturn;
    }
}

