/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.core.internal.applicability;

import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BlockApplicabilityStageRequest;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.orcs.core.internal.applicability.BlockApplicabilityOps;

public class StagedFileWatcher {
    private WatchService watchService;
    private final Map<WatchKey, Path> keyMap = new HashMap<WatchKey, Path>();
    private final Map<ArtifactToken, Pair<String, BlockApplicabilityOps>> viewMap = new HashMap<ArtifactToken, Pair<String, BlockApplicabilityOps>>();
    private final XResultData results;

    public StagedFileWatcher(XResultData results) {
        this.results = results;
    }

    public void runWatcher(BlockApplicabilityStageRequest data, String directory) {
        try {
            WatchKey key;
            this.watchService = FileSystems.getDefault().newWatchService();
            Path dir = Paths.get(directory, new String[0]);
            Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    String fileName = dir.getFileName().toString();
                    if (!(fileName.equals("Staging") || fileName.startsWith(".") && dir.toFile().isDirectory())) {
                        WatchKey key = dir.register(StagedFileWatcher.this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
                        StagedFileWatcher.this.keyMap.put(key, dir);
                        return FileVisitResult.CONTINUE;
                    }
                    return FileVisitResult.SKIP_SUBTREE;
                }
            });
            while ((key = this.watchService.take()) != null) {
                ArrayList<String> files = new ArrayList<String>();
                for (WatchEvent<?> watchEvent : key.pollEvents()) {
                    Path path = this.keyMap.get(key);
                    String filePath = path.resolve((Path)watchEvent.context()).toString();
                    filePath = filePath.replace(directory, "");
                    files.add(filePath);
                }
                for (Map.Entry entry : this.viewMap.entrySet()) {
                    String stagePath = (String)((Pair)entry.getValue()).getFirst();
                    BlockApplicabilityOps ops = (BlockApplicabilityOps)((Pair)entry.getValue()).getSecond();
                    this.results.logf("File Watcher has started processing files for %s\n", new Object[]{((ArtifactToken)entry.getKey()).getName()});
                    ops.refreshStagedFiles(this.results, directory, stagePath, files);
                    if (this.results.isErrors()) {
                        this.results.warningf("See above for errors while refreshing %s\n", new Object[]{((ArtifactToken)entry.getKey()).getName()});
                    }
                    this.results.logf("File Watcher has completed file processing for %s\n", new Object[]{((ArtifactToken)entry.getKey()).getName()});
                }
                key.reset();
            }
            this.watchService.close();
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
            return;
        }
        catch (IOException | InterruptedException ex) {
            this.results.error(ex.getMessage());
        }
    }

    public void stopWatcher() {
        try {
            this.watchService.close();
            this.keyMap.clear();
            this.viewMap.clear();
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
    }

    public void addView(ArtifactToken view, String stagePath, BlockApplicabilityOps ops) {
        this.viewMap.put(view, (Pair<String, BlockApplicabilityOps>)new Pair((Object)stagePath, (Object)ops));
    }
}

