/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.template.engine;

import java.io.IOException;
import org.eclipse.osee.framework.jdk.core.type.NamedId;
import org.eclipse.osee.template.engine.AppendableRule;

public abstract class OptionsRule<T extends NamedId>
extends AppendableRule<T> {
    private final String listId;

    protected String getListId() {
        return this.listId;
    }

    public OptionsRule(String ruleName) {
        this(ruleName, null);
    }

    public OptionsRule(String ruleName, String listId) {
        super(ruleName);
        this.listId = listId;
    }

    @Override
    public void applyTo(Appendable appendable) throws IOException {
        if (this.listId == null) {
            this.appendOptions(appendable);
        } else {
            appendable.append("\n<datalist id=\"");
            appendable.append(this.listId);
            appendable.append("\">\n");
            this.appendOptions(appendable);
            appendable.append("</datalist>\n");
        }
    }

    public abstract Iterable<T> getOptions();

    @Override
    public void applyTo(Appendable appendable, T option) throws IOException {
        appendable.append("<option value=\"");
        appendable.append(option.getName());
        appendable.append("\" guid=\"");
        appendable.append(option.getIdString());
        appendable.append("\">\n");
    }

    private void appendOptions(Appendable appendable) throws IOException {
        for (NamedId option : this.getOptions()) {
            this.applyTo(appendable, (T)option);
        }
    }
}

