/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.transaction;

import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitor;
import org.eclipse.osee.framework.skynet.core.transaction.TxMonitorCache;

public final class TxMonitorImpl<K>
implements TxMonitor<K> {
    private final TxMonitorCache<K> cache;

    public TxMonitorImpl(TxMonitorCache<K> cache) {
        this.cache = cache;
    }

    @Override
    public void checkForComodification(K key, MonitoredTx tx, Object object) {
        for (MonitoredTx otherTx : this.cache.getTxs(key)) {
            if (otherTx.equals(tx) || !otherTx.containsItem(object)) continue;
            throw new OseeStateException("Co-modification error for object [%s] -\ntx1:[%s]\ntx2:[%s]", new Object[]{object, tx, otherTx});
        }
    }

    @Override
    public void createTx(K key, MonitoredTx tx) {
        if (this.cache.contains(key, tx.getUuid())) {
            throw new OseeStateException("key:[%s] tx:[%s] - transaction was already in the cache", new Object[]{key, tx});
        }
        if (tx.getTxState() != TxState.CREATED) {
            throw new OseeStateException("key:[%s] tx:[%s] state:[%s] - was not in CREATED state ", new Object[]{key, tx, tx.getTxState()});
        }
        this.cache.putTx(key, tx);
    }

    @Override
    public void beginTx(K key, MonitoredTx tx) {
        this.checkIsInCache(key, tx);
        TxState state = tx.getTxState();
        if (state != TxState.CREATED && state != TxState.MODIFIED) {
            throw new OseeStateException("key:[%s] tx:[%s] state:[%s] - was not in CREATED or MODIFIED_STATE state", new Object[]{key, tx, state});
        }
    }

    @Override
    public void endTx(K key, MonitoredTx tx) {
        this.checkIsInCache(key, tx);
        TxState state = tx.getTxState();
        if (state != TxState.ENDED && state != TxState.ENDED_WITH_EXCEPTION) {
            throw new OseeStateException("key:[%s] tx:[%s] state:[%s] - was not in ENDED or ENDED_WITH_EXCEPTION state", new Object[]{key, tx, state});
        }
        this.cache.removeTx(key, tx.getUuid());
    }

    @Override
    public void rollbackTx(K key, MonitoredTx tx) {
        this.checkIsInCache(key, tx);
        tx.rollback();
    }

    private void checkIsInCache(K key, MonitoredTx tx) {
        if (!this.cache.contains(key, tx.getUuid())) {
            throw new OseeStateException("key:[%s] tx:[%s] - has not been added to monitor", new Object[]{key, tx});
        }
    }

    @Override
    public void cancel(K key, MonitoredTx tx) {
        this.cache.removeTx(key, tx.getUuid());
    }

    public static interface MonitoredTx {
        public String getUuid();

        public TxState getTxState();

        public boolean containsItem(Object var1);

        public void rollback();
    }

    public static enum TxState {
        CREATED,
        MODIFIED,
        RUNNING,
        ENDED,
        ENDED_WITH_EXCEPTION;

    }
}

