/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.resolvers;

import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IArtifactImportResolver;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IRoughArtifactTranslator;

public class NewArtifactImportResolver
implements IArtifactImportResolver {
    private final IRoughArtifactTranslator translator;
    private final ArtifactTypeToken primaryArtifactType;

    public NewArtifactImportResolver(IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType) {
        this.translator = translator;
        this.primaryArtifactType = primaryArtifactType;
    }

    public NewArtifactImportResolver(IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, ArtifactTypeToken tertiaryArtifactType, ArtifactTypeToken quaternaryArtifactType) {
        this.translator = translator;
        this.primaryArtifactType = primaryArtifactType;
    }

    protected IRoughArtifactTranslator getTranslator() {
        return this.translator;
    }

    @Override
    public Artifact resolve(RoughArtifact roughArtifact, BranchToken branch, Artifact realParent, Artifact root) {
        ArtifactTypeToken artifactType = this.getArtifactType(roughArtifact);
        OseeLog.logf(NewArtifactImportResolver.class, (Level)Level.INFO, (String)"New artifact: [%s]. Attributes: [%s]", (Object[])new Object[]{roughArtifact, roughArtifact.getAttributes()});
        Artifact realArtifact = ArtifactTypeManager.addArtifact(artifactType, branch, null, roughArtifact.getGuid(), null);
        this.translator.translate(roughArtifact, realArtifact);
        return realArtifact;
    }

    private ArtifactTypeToken getArtifactType(RoughArtifact art) {
        if (!this.primaryArtifactType.equals(ArtifactTypeId.SENTINEL)) {
            return this.primaryArtifactType;
        }
        return art.getArtifactType();
    }
}

