/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.httpRequests;

import org.eclipse.osee.framework.core.client.server.HttpRequest;
import org.eclipse.osee.framework.core.client.server.HttpResponse;
import org.eclipse.osee.framework.core.client.server.IHttpServerRequest;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.plugin.core.util.ExtensionDefinedObjects;
import org.eclipse.osee.framework.skynet.core.httpRequests.IClientLoopbackCmd;

public class ClientLoopbackHandler
implements IHttpServerRequest {
    private static final ExtensionDefinedObjects<IClientLoopbackCmd> commands = new ExtensionDefinedObjects("org.eclipse.osee.framework.skynet.core.ClientLoopbackCmd", "ClientLoopbackCmd", "className");

    public String getRequestType() {
        return "osee/loopback";
    }

    public void processRequest(HttpRequest httpRequest, HttpResponse httpResponse) {
        String cmd = httpRequest.getParameter("cmd");
        if (Strings.isValid((String)cmd)) {
            boolean wasProcessed = false;
            for (IClientLoopbackCmd command : commands.getObjects()) {
                if (!command.isApplicable(cmd)) continue;
                wasProcessed = true;
                command.execute(httpRequest.getParameters(), httpResponse);
            }
            if (!wasProcessed) {
                httpResponse.outputStandardError(404, String.format("Unable to process request: [%s]", httpRequest.getRawRequest()));
            }
        } else {
            httpResponse.outputStandardError(400, String.format("Unable to process request: [%s]", httpRequest.getRawRequest()));
        }
    }
}

