/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.EventTopicTransferType;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.model.event.DefaultBasicIdRelation;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactTopicEvent;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidRelation;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationTransfer;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.utility.AbstractDbTxOperation;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.framework.skynet.core.utility.Id4JoinQuery;
import org.eclipse.osee.framework.skynet.core.utility.JoinUtility;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcStatement;

public class PurgeArtifacts
extends AbstractDbTxOperation {
    private static final String SELECT_ITEM_GAMMAS = "SELECT DISTINCT %s txs.gamma_id, txs.transaction_id, branch_id, aj.id4 FROM osee_join_id4 aj, %s item, osee_txs txs WHERE aj.query_id = ? AND %s AND item.gamma_id = txs.gamma_id AND aj.id1 = txs.branch_id";
    private static final String COUNT_ARTIFACT_VIOLATIONS = "SELECT art.art_id, txs.branch_id, aj.id4 FROM osee_join_id4 aj, osee_artifact art, osee_txs txs WHERE aj.query_id = ? AND aj.id2 = art.art_id AND art.gamma_id = txs.gamma_id AND txs.branch_id = aj.id1";
    private static final String DELETE_FROM_TXS_USING_JOIN_TRANSACTION = "DELETE FROM osee_txs txs WHERE EXISTS (select 1 from osee_join_id4 jt WHERE jt.query_id = ? AND jt.id3 = txs.branch_id AND jt.id1 = txs.gamma_id AND jt.id2 = txs.transaction_id)";
    private final Set<Artifact> artifactsToPurge;
    private final StringBuilder sb = new StringBuilder();
    private boolean success;
    private final boolean recurseChildrenBranches;
    private ArtifactEvent artifactEvent;
    private ArtifactTopicEvent artifactTopicEvent;
    private static final boolean useNewEvents = FrameworkEventUtil.USE_NEW_EVENTS;

    public PurgeArtifacts(Collection<? extends Artifact> artifactsToPurge) {
        this(artifactsToPurge, false);
    }

    public PurgeArtifacts(Collection<? extends Artifact> artifactsToPurge, boolean recurseChildrenBranches) {
        super(ConnectionHandler.getJdbcClient(), "Purge Artifact", "org.eclipse.osee.framework.skynet.core");
        this.artifactsToPurge = new HashSet<Artifact>(artifactsToPurge);
        this.success = false;
        this.recurseChildrenBranches = recurseChildrenBranches;
    }

    @Override
    protected void doTxWork(IProgressMonitor monitor, JdbcConnection connection) {
        if (this.artifactsToPurge == null || this.artifactsToPurge.isEmpty()) {
            return;
        }
        this.checkPurgeValid(connection);
        HashSet<Artifact> childreArtifactsToPurge = new HashSet<Artifact>();
        for (Artifact art : this.artifactsToPurge) {
            childreArtifactsToPurge.addAll(art.getDescendants(DeletionFlag.INCLUDE_DELETED));
        }
        this.artifactsToPurge.addAll(childreArtifactsToPurge);
        Throwable throwable = null;
        Iterator<Artifact> iterator = null;
        try (Id4JoinQuery artJoin2 = JoinUtility.createId4JoinQuery(this.getJdbcClient(), connection);){
            for (Artifact art : this.artifactsToPurge) {
                artJoin2.add((Id)art.getBranch(), (Id)art, (Id)TransactionId.SENTINEL, (Id)art.getBranch().getViewId());
            }
            artJoin2.store();
            Long queryId = artJoin2.getQueryId();
            Object object = null;
            Object var9_12 = null;
            try (Id4JoinQuery txJoin = JoinUtility.createId4JoinQuery(this.getJdbcClient(), connection);){
                this.insertSelectItems(txJoin, connection, "osee_relation_link", "(aj.id2 = item.a_art_id OR aj.id2 = item.b_art_id)", queryId);
                this.insertSelectItems(txJoin, connection, "osee_attribute", "aj.id2 = item.art_id", queryId);
                this.insertSelectItems(txJoin, connection, "osee_artifact", "aj.id2 = item.art_id", queryId);
                txJoin.store();
                this.getJdbcClient().runPreparedUpdate(connection, DELETE_FROM_TXS_USING_JOIN_TRANSACTION, new Object[]{txJoin.getQueryId()});
            }
            catch (Throwable throwable2) {
                if (object == null) {
                    object = throwable2;
                } else if (object != throwable2) {
                    ((Throwable)object).addSuppressed(throwable2);
                }
                throw object;
            }
            BranchToken branch = this.artifactsToPurge.iterator().next().getBranch();
            if (useNewEvents) {
                this.artifactTopicEvent = new ArtifactTopicEvent((BranchId)branch);
                for (Artifact art : this.artifactsToPurge) {
                    EventTopicArtifactTransfer transferArt = FrameworkEventUtil.artifactTransferFactory((BranchId)art.getBranch(), art, (ArtifactTypeId)art.getArtifactType(), EventModType.Purged, null, null, EventTopicTransferType.BASE);
                    this.artifactTopicEvent.addArtifact(transferArt);
                    for (RelationLink relationLink : art.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
                        EventTopicRelationTransfer transfer = FrameworkEventUtil.relationTransferFactory(RelationEventType.Purged, relationLink.getArtifactA(), relationLink.getArtifactB(), RelationId.valueOf((Long)relationLink.getRelationType().getId()), relationLink.getRelationType().getId(), relationLink.getGammaId(), "PurgeArtifacts transfer");
                        this.artifactTopicEvent.addRelation(transfer);
                        relationLink.markAsPurged();
                    }
                    for (Attribute attribute : art.internalGetAttributes()) {
                        attribute.markAsPurged();
                    }
                    ArtifactCache.deCache(art);
                    RelationManager.deCache(art);
                    art.internalSetDeleted();
                }
                this.success = true;
            } else {
                this.artifactEvent = new ArtifactEvent((BranchId)branch);
                for (Artifact artifact : this.artifactsToPurge) {
                    EventBasicGuidArtifact guidArt = new EventBasicGuidArtifact(EventModType.Purged, artifact);
                    this.artifactEvent.addArtifact(guidArt);
                    for (RelationLink relationLink : artifact.getRelationsAll(DeletionFlag.EXCLUDE_DELETED)) {
                        Artifact artifactA = relationLink.getArtifactA();
                        Artifact artifactB = relationLink.getArtifactB();
                        DefaultBasicIdRelation guidRelation = new DefaultBasicIdRelation((BranchId)branch, relationLink.getRelationType().getId(), relationLink.getId(), relationLink.getGammaId(), new DefaultBasicGuidArtifact((BranchId)branch, (ArtifactToken)artifactA), new DefaultBasicGuidArtifact((BranchId)branch, (ArtifactToken)artifactB));
                        this.artifactEvent.addRelation(new EventBasicGuidRelation(RelationEventType.Purged, (ArtifactId)artifactA, (ArtifactId)artifactB, guidRelation));
                        relationLink.markAsPurged();
                    }
                    for (Attribute attribute : artifact.internalGetAttributes()) {
                        attribute.markAsPurged();
                    }
                    ArtifactCache.deCache(artifact);
                    RelationManager.deCache(artifact);
                    artifact.internalSetDeleted();
                }
                this.success = true;
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    @Override
    protected void handleTxFinally(IProgressMonitor monitor) {
        if (this.success) {
            if (useNewEvents) {
                OseeEventManager.kickArtifactTopicEvent(PurgeArtifacts.class, this.artifactTopicEvent);
            } else {
                OseeEventManager.kickPersistEvent(PurgeArtifacts.class, this.artifactEvent);
            }
        }
    }

    public void insertSelectItems(Id4JoinQuery txJoin, JdbcConnection connection, String tableName, String artifactJoinSql, Long queryId) {
        String query = String.format(SELECT_ITEM_GAMMAS, this.getJdbcClient().getOrderedHint(), tableName, artifactJoinSql);
        Throwable throwable = null;
        Object var8_9 = null;
        try (JdbcStatement chStmt = this.getJdbcClient().getStatement(connection);){
            chStmt.runPreparedQuery(query, new Object[]{queryId});
            while (chStmt.next()) {
                txJoin.add(chStmt.getLong("gamma_id"), chStmt.getLong("transaction_id"), chStmt.getLong("branch_id"));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void checkPurgeValid(JdbcConnection connection) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Id4JoinQuery artJoin = JoinUtility.createId4JoinQuery(this.getJdbcClient(), connection);){
            for (Artifact art : this.artifactsToPurge) {
                for (BranchToken branch : BranchManager.getChildBranches((BranchId)art.getBranch(), true)) {
                    artJoin.add((Id)branch, (Id)art, (Id)TransactionId.SENTINEL, (Id)branch.getViewId());
                }
            }
            if (!artJoin.isEmpty()) {
                artJoin.store();
                this.getJdbcClient().runQuery(connection, this::getArtifactViloation, COUNT_ARTIFACT_VIOLATIONS, new Object[]{artJoin.getQueryId()});
                if (this.sb.length() > 0) {
                    throw new OseeCoreException("Can't purge because the following artifacts exist on child branches.\n%s", new Object[]{this.sb});
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void getArtifactViloation(JdbcStatement stmt) {
        ArtifactId artId = ArtifactId.valueOf((Long)stmt.getLong("art_id"));
        BranchId branch = BranchId.valueOf((Long)stmt.getLong("branch_id"));
        if (this.recurseChildrenBranches) {
            Artifact artifactFromId = ArtifactQuery.getArtifactFromId(artId, branch);
            this.artifactsToPurge.add(artifactFromId);
        } else {
            this.sb.append("ArtifactId[");
            this.sb.append(artId);
            this.sb.append("] BranchId[");
            this.sb.append(branch);
            this.sb.append("]\n");
        }
    }
}

