/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.exception.MultipleArtifactsExist;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.OseeSystemArtifacts;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationLink;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;

public class IntroduceArtifactOperation {
    private final Artifact fosterParent;
    private final BranchToken destinationBranch;
    private Collection<Artifact> sourceArtifacts;
    private List<Artifact> destinationArtifacts;

    public IntroduceArtifactOperation(BranchToken destinationBranch) {
        this(OseeSystemArtifacts.getDefaultHierarchyRootArtifact((BranchId)destinationBranch));
    }

    public IntroduceArtifactOperation(Artifact fosterParent) {
        this.fosterParent = fosterParent;
        this.destinationBranch = fosterParent.getBranch();
    }

    public Artifact introduce(Artifact sourceArtifact) {
        this.introduce(Arrays.asList(sourceArtifact));
        return this.destinationArtifacts.get(0);
    }

    public List<Artifact> introduce(Collection<Artifact> sourceArtifacts) {
        this.sourceArtifacts = sourceArtifacts;
        this.destinationArtifacts = new ArrayList<Artifact>(sourceArtifacts.size());
        for (Artifact sourceArtifact : sourceArtifacts) {
            this.introduceArtifact(sourceArtifact);
        }
        return this.destinationArtifacts;
    }

    private void introduceArtifact(Artifact sourceArtifact) {
        Artifact destinationArtifact = ArtifactQuery.getArtifactOrNull((ArtifactId)sourceArtifact, (BranchId)this.destinationBranch, DeletionFlag.INCLUDE_DELETED);
        if (destinationArtifact == null) {
            destinationArtifact = sourceArtifact.introduceShallowArtifact(this.destinationBranch);
            this.processArtifact(sourceArtifact, destinationArtifact);
        } else {
            destinationArtifact.introduce(sourceArtifact);
            this.processArtifact(sourceArtifact, destinationArtifact);
        }
        destinationArtifact.meetMinimumAttributeCounts(true);
        this.destinationArtifacts.add(destinationArtifact);
    }

    private void processArtifact(Artifact sourceArtifact, Artifact destinationArtifact) {
        this.introduceAttributes(sourceArtifact, destinationArtifact);
        if (!sourceArtifact.isHistorical()) {
            this.introduceRelations(sourceArtifact, destinationArtifact);
            try {
                if (sourceArtifact.hasParent() && !destinationArtifact.hasParent() && !this.sourceArtifacts.contains((Object)sourceArtifact.getParent())) {
                    this.fosterParent.addChild(destinationArtifact);
                }
            }
            catch (MultipleArtifactsExist multipleArtifactsExist) {
                this.fosterParent.addChild(destinationArtifact);
            }
        } else {
            OseeLog.logf(Activator.class, (Level)Level.INFO, (String)"Historical relations are only supported on the server. Artifact [%s] is historical", (Object[])new Object[]{sourceArtifact});
        }
    }

    private void introduceAttributes(Artifact sourceArtifact, Artifact destinationArtifact) {
        List<Attribute<?>> sourceAttributes = sourceArtifact.getAttributes(true);
        this.removeNewAttributesFromDestination(sourceArtifact, destinationArtifact);
        for (Attribute<?> sourceAttribute : sourceAttributes) {
            if (!destinationArtifact.isAttributeTypeValid((AttributeTypeId)sourceAttribute.getAttributeType())) continue;
            this.introduceAttribute(sourceAttribute, destinationArtifact);
        }
    }

    private void introduceAttribute(Attribute<?> sourceAttribute, Artifact destinationArtifact) {
        if (sourceAttribute.isDirty()) {
            throw new OseeArgumentException("The un-persisted attribute [%s] can not be introduced until it is persisted.", new Object[]{sourceAttribute});
        }
        if (sourceAttribute.isInDb()) {
            Attribute<?> destinationAttribute = destinationArtifact.getAttributeById(sourceAttribute.getId(), true);
            if (destinationAttribute == null) {
                destinationArtifact.internalInitializeAttribute(sourceAttribute.getAttributeType(), (AttributeId)sourceAttribute, sourceAttribute.getGammaId(), sourceAttribute.getModificationType(), sourceAttribute.getApplicabilityId(), true, sourceAttribute.getAttributeDataProvider().getData()).internalSetModType(sourceAttribute.getModificationType(), true, true);
            } else {
                destinationAttribute.introduce(sourceAttribute);
            }
        }
    }

    private void introduceRelations(Artifact sourceArtifact, Artifact destinationArtifact) {
        List<RelationLink> sourceRelations = sourceArtifact.getRelationsAll(DeletionFlag.INCLUDE_DELETED);
        for (RelationLink sourceRelation : sourceRelations) {
            this.introduceRelation(sourceRelation, destinationArtifact);
        }
    }

    private void introduceRelation(RelationLink sourceRelation, Artifact destinationArtifact) {
        if (sourceRelation.isDirty()) {
            throw new OseeArgumentException("The un-persisted relation [%s] can not be introduced until it is persisted.", new Object[]{sourceRelation});
        }
        if (sourceRelation.isInDb()) {
            ArtifactToken srcArtB;
            ArtifactToken srcArtA = sourceRelation.getArtifactIdA();
            RelationLink destinationRelation = RelationManager.getLoadedRelationById((RelationId)sourceRelation, (ArtifactId)srcArtA, (ArtifactId)(srcArtB = sourceRelation.getArtifactIdB()), this.destinationBranch);
            if (destinationRelation == null) {
                if (this.doesRelatedArtifactExist(destinationArtifact, (ArtifactId)srcArtA, (ArtifactId)srcArtB)) {
                    ModificationType modType = sourceRelation.getModificationType();
                    ArtifactToken destArtA = ArtifactToken.valueOf((ArtifactToken)srcArtA, (BranchToken)this.destinationBranch);
                    ArtifactToken destArtB = ArtifactToken.valueOf((ArtifactToken)srcArtB, (BranchToken)this.destinationBranch);
                    destinationRelation = RelationManager.getOrCreate(destArtA, destArtB, sourceRelation.getRelationType(), (RelationId)sourceRelation, sourceRelation.getGammaId(), sourceRelation.getRationale(), modType, sourceRelation.getApplicabilityId());
                    destinationRelation.internalSetModType(modType, true, true);
                }
            } else {
                destinationRelation.introduce(sourceRelation.getGammaId(), sourceRelation.getModificationType());
            }
        }
    }

    private void removeNewAttributesFromDestination(Artifact sourceArtifact, Artifact destinationArtifact) {
        List<Attribute<?>> destAttributes = destinationArtifact.getAttributes(true);
        for (Attribute<?> destAttribute : destAttributes) {
            Attribute<?> attribute = sourceArtifact.getAttributeById(destAttribute.getId(), true);
            if (attribute != null) continue;
            destAttribute.delete();
        }
    }

    private boolean doesRelatedArtifactExist(Artifact destinationArtifact, ArtifactId aArtifactId, ArtifactId bArtifactId) {
        boolean found;
        ArtifactId otherId = destinationArtifact.equals(aArtifactId.getId()) ? bArtifactId : aArtifactId;
        Artifact otherArtifact = ArtifactQuery.checkArtifactFromId(otherId, (BranchId)this.destinationBranch);
        boolean bl = found = otherArtifact != null;
        if (!found) {
            for (Artifact sourceArtifact : this.sourceArtifacts) {
                if (!sourceArtifact.equals(otherId)) continue;
                return true;
            }
        }
        return found;
    }
}

