/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.demo.populate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.osee.ats.api.task.JaxAtsTask;
import org.eclipse.osee.ats.api.task.NewTaskData;
import org.eclipse.osee.ats.api.task.NewTaskSet;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.demo.DemoUtil;
import org.eclipse.osee.ats.ide.demo.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;

public class Pdd90CreateDemoTasks {
    public void run() throws Exception {
        Date createdDate = new Date();
        AtsUser createdBy = AtsApiService.get().getUserService().getCurrentUser();
        boolean firstTaskWorkflow = true;
        NewTaskSet newTaskSet = NewTaskSet.create((String)"Populate Demo DB - Create Tasks", (AtsUser)createdBy);
        for (TeamWorkFlowArtifact codeArt : Arrays.asList(DemoUtil.getSawCodeCommittedWf(), DemoUtil.getSawCodeUnCommittedWf())) {
            NewTaskData newTaskData = NewTaskData.create((NewTaskSet)newTaskSet, (IAtsTeamWorkflow)codeArt);
            ArrayList<String> assigneeUserIds = new ArrayList<String>();
            if (firstTaskWorkflow) {
                assigneeUserIds.add(DemoUsers.Joe_Smith.getUserId());
                assigneeUserIds.add(DemoUsers.Kay_Jones.getUserId());
            } else {
                assigneeUserIds.add(DemoUsers.Joe_Smith.getUserId());
            }
            for (String title : firstTaskWorkflow ? DemoUtil.Saw_Code_Committed_Task_Titles : DemoUtil.Saw_Code_UnCommitted_Task_Titles) {
                JaxAtsTask task = JaxAtsTask.create((NewTaskData)newTaskData, (String)title, (AtsUser)createdBy, (Date)createdDate);
                task.setRelatedToState(codeArt.getCurrentStateName());
                task.setAssigneeUserIds(assigneeUserIds);
            }
            firstTaskWorkflow = false;
        }
        newTaskSet = AtsApiService.get().getTaskService().createTasks(newTaskSet);
        if (newTaskSet.isErrors()) {
            throw new OseeStateException("Task gen did not succeed [%s]", new Object[]{newTaskSet.getResults().toString()});
        }
    }
}

