/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.support.test.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;
import org.eclipse.osee.support.test.util.UnitTestUtil;

public class UnitTestCounter {
    private static int unitTestCount = 0;
    private static int testPointCount = 0;
    private static final CountingMap<String> authorToFileCount = new CountingMap(10);
    private static final CountingMap<String> authorToTestPointCount = new CountingMap(10);

    public static void main(String[] args) {
        try {
            StringBuffer results = new StringBuffer();
            StringBuffer errors = new StringBuffer();
            for (String dirNam : Arrays.asList("C:\\UserData\\git\\org.eclipse.osee\\plugins\\", "C:\\UserData\\git\\lba.osee\\plugins\\")) {
                File dir1 = new File(dirNam);
                for (String filename : Lib.readListFromDir((File)dir1, (FilenameFilter)new MatchFilter(".*\\.test"), (boolean)true)) {
                    if (!Strings.isValid((String)filename)) continue;
                    System.out.println(String.format("Processing [%s]", filename));
                    File file = new File(dir1 + "\\" + filename);
                    UnitTestCounter.recurseAndFind(file, results, errors);
                }
            }
            results.append("\n\nTest Unit Total (file with at least 1 test case), " + unitTestCount + "\n");
            ArrayList<String> names = new ArrayList<String>();
            for (Map.Entry entry : authorToFileCount.getCounts()) {
                System.out.println(String.format("Author [%s]", entry.getKey()));
                names.add(String.valueOf((String)entry.getKey()) + ", " + entry.getValue() + "\n");
            }
            Collections.sort(names);
            for (String name : names) {
                results.append(name);
            }
            results.append("\n\nTest Case Total (@org.junit.Test or @Test), " + testPointCount + "\n");
            names.clear();
            for (Map.Entry entry : authorToTestPointCount.getCounts()) {
                names.add(String.valueOf((String)entry.getKey()) + ", " + entry.getValue() + "\n");
            }
            Collections.sort(names);
            for (String name : names) {
                results.append(name);
            }
            results.append("\n\n");
            results.append(results.toString());
            XConsoleLogger.err((String)("\n\n" + errors), (Object[])new Object[0]);
            String outputFilename = "C:\\UserData\\UnitTestCounter.csv";
            System.out.println("\n\nResults written to " + outputFilename + "\n");
            Lib.writeStringToFile((String)(String.valueOf(errors.toString()) + "\n\n" + results.toString()), (File)new File(outputFilename));
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    private static void recurseAndFind(File file, StringBuffer results, StringBuffer errors) throws IOException {
        if (file.isDirectory()) {
            for (String filename : Lib.readListFromDir((File)file, (FilenameFilter)new MatchFilter(".*"), (boolean)true)) {
                File childFile = new File(String.valueOf(file.getAbsolutePath()) + "\\" + filename);
                UnitTestCounter.recurseAndFind(childFile, results, errors);
            }
        }
        if (file.getAbsolutePath().endsWith(".java") && !file.getName().contains("UnitTestCounter") && !file.getName().contains("UnitTestUtil")) {
            String text = Lib.fileToString((File)file);
            if (UnitTestUtil.isUnitTest(text) || file.getAbsolutePath().endsWith("Test.java")) {
                results.append(String.valueOf(file.getName()) + ", ");
                ++unitTestCount;
                Set<String> authors = UnitTestUtil.getAuthors(text);
                if (authors.isEmpty()) {
                    errors.append(String.format("File [%s] has no authors\n", file.getName()));
                }
                int fileTestPointCount = UnitTestUtil.getTestMethodCount(text);
                int fileTestPointCountFromSuperclass = UnitTestUtil.getTestMethodCountFromSuperclass(file, text);
                int totalFileTestPointCount = fileTestPointCount + fileTestPointCountFromSuperclass;
                testPointCount += totalFileTestPointCount;
                for (String author : authors) {
                    results.append(String.valueOf(author) + "; ");
                    authorToFileCount.put((Object)author);
                    authorToTestPointCount.put((Object)author, fileTestPointCount + fileTestPointCountFromSuperclass);
                }
                XConsoleLogger.err((String)String.format("[%s] tests [ main:%s super:%s ]found in %s", totalFileTestPointCount, fileTestPointCount, fileTestPointCountFromSuperclass, file.getName()), (Object[])new Object[0]);
                results.append("\n");
            } else if (!(UnitTestUtil.isSuite(file) || UnitTestUtil.isMock(file) || UnitTestUtil.isTestUtil(file))) {
                System.out.println("NOT TEST FILE " + file.getName());
            }
        }
    }
}

