/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.define.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.osee.ote.define.parser.CollectionParser;
import org.eclipse.osee.ote.define.parser.ICollectionSource;
import org.eclipse.osee.ote.define.parser.ISaxElementHandler;
import org.xml.sax.Attributes;

public class SaxChunkCollector {
    private final Set<String> collectionElement = new HashSet<String>();
    private int currentDepth = 0;
    private boolean isCollecting = false;
    private final StringBuilder builder;
    private final List<String> collectionChunks;
    private final ISaxElementHandler handler;
    private String currentLocalName;

    public SaxChunkCollector(ISaxElementHandler handler, String ... collect) {
        String[] stringArray = collect;
        int n = collect.length;
        int n2 = 0;
        while (n2 < n) {
            String item = stringArray[n2];
            this.collectionElement.add(item);
            ++n2;
        }
        this.handler = handler;
        this.collectionChunks = new ArrayList<String>();
        this.builder = new StringBuilder(5000);
    }

    public void endElementFound(String localName, ICollectionSource collectionSource) {
        if (this.isCollecting) {
            --this.currentDepth;
            this.builder.append(collectionSource.getContents());
            this.builder.append("</");
            this.builder.append(localName);
            this.builder.append(">");
            if (this.currentDepth < 1) {
                this.isCollecting = false;
                String data = this.builder.toString();
                this.collectionChunks.add(data);
                this.handler.processSaxChunkCollectorData(this.currentLocalName, data);
                this.builder.setLength(0);
            }
        }
    }

    public ISaxElementHandler getHandler() {
        return this.handler;
    }

    public void startElementFound(String localName, Attributes attributes, CollectionParser collectionParser) {
        if (this.collectionElement.contains(localName)) {
            this.isCollecting = true;
            this.currentLocalName = localName;
        }
        if (this.isCollecting) {
            ++this.currentDepth;
            this.builder.append("<");
            this.builder.append(localName);
            int i = 0;
            while (i < attributes.getLength()) {
                this.builder.append(" ");
                this.builder.append(attributes.getLocalName(i));
                this.builder.append("=\"");
                this.builder.append(attributes.getValue(i));
                this.builder.append("\"");
                ++i;
            }
            this.builder.append(" >");
        }
    }
}

