/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.text;

import java.io.File;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.osee.framework.jdk.core.text.RuleRecord;
import org.eclipse.osee.framework.jdk.core.util.xml.Jaxp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RulesLogHandler
extends Handler {
    private final Document document;
    private final File outFile;
    private final Element rootElement;

    public RulesLogHandler(File outFile) throws ParserConfigurationException {
        this.outFile = outFile;
        this.document = Jaxp.newDocumentNamespaceAware();
        this.rootElement = this.document.createElement("Rule");
        this.document.appendChild(this.rootElement);
    }

    public void writeOutFile() {
        if (this.rootElement.hasChildNodes()) {
            try {
                Jaxp.writeXmlDocument(this.document, this.outFile, Jaxp.getPrettyFormat());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (logRecord instanceof RuleRecord) {
            RuleRecord record = (RuleRecord)logRecord;
            this.rootElement.appendChild(record.toXml(this.document));
        } else {
            this.rootElement.appendChild(Jaxp.createElement(this.document, logRecord.getLevel().getName(), logRecord.getMessage()));
        }
    }

    @Override
    public void close() throws SecurityException {
        this.writeOutFile();
    }

    @Override
    public void flush() {
        throw new UnsupportedOperationException();
    }
}

