/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.actions.EditAssigneeAction;
import org.eclipse.osee.ats.ide.actions.EditBlockedStatusAction;
import org.eclipse.osee.ats.ide.actions.EditHoldStatusAction;
import org.eclipse.osee.ats.ide.actions.EditStatusAction;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.ats.ide.workflow.transition.TransitionToMenu;
import org.eclipse.osee.ats.ide.world.AtsWorldEditorItems;
import org.eclipse.osee.ats.ide.world.IAtsWorldEditorItem;
import org.eclipse.osee.ats.ide.world.WorldXViewer;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.swt.widgets.Composite;

public class TaskXViewer
extends WorldXViewer {
    Action editAssigneeAction;
    EditBlockedStatusAction editBlockedStatusAction;
    EditHoldStatusAction editHoldStatusAction;
    private boolean tasksEditable = true;
    private IAtsTeamWorkflow teamWf;

    public TaskXViewer(Composite parent, int style, IXViewerFactory xViewerFactory, IDirtiableEditor editor, IAtsTeamWorkflow teamWf) {
        super(parent, style, xViewerFactory, editor);
        this.teamWf = teamWf;
    }

    @Override
    public void createMenuActions() {
        super.createMenuActions();
        this.editStatusAction = new EditStatusAction(this, this, this);
        this.editAssigneeAction = new EditAssigneeAction(this, this);
        this.editBlockedStatusAction = new EditBlockedStatusAction(this);
        this.editHoldStatusAction = new EditHoldStatusAction(this);
    }

    @Override
    public void updateEditMenuActions() {
        MenuManager mm = this.getMenuManager();
        for (IAtsWorldEditorItem item : AtsWorldEditorItems.getItems()) {
            item.updateTaskEditMenuActions(this);
        }
        MenuManager editMenuManager = this.updateEditMenu(mm);
        mm.insertBefore("ATS WORLD EDIT", (IContributionItem)editMenuManager);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)TransitionToMenu.createTransitionToMenuManager(this.thisXViewer, "Transition-To", this.getSelectedWorkflowArtifacts()));
        mm.insertBefore("ATS WORLD EDIT", (IAction)this.editStatusAction);
        this.editStatusAction.setEnabled(this.isTasksEditable() && this.getSelectedArtifacts().size() > 0);
        mm.insertBefore("ATS WORLD EDIT", (IAction)this.editAssigneeAction);
        this.editAssigneeAction.setEnabled(this.isTasksEditable() && this.getSelectedArtifacts().size() > 0);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IContributionItem)new Separator());
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editBlockedStatusAction);
        this.editBlockedStatusAction.setEnabled(this.getSelectedWorkflowArtifacts().size() >= 1);
        mm.insertBefore("XVIEWER MENU GROUP PRE", (IAction)this.editHoldStatusAction);
        this.editHoldStatusAction.setEnabled(this.getSelectedWorkflowArtifacts().size() >= 1);
    }

    public boolean isTasksEditable() {
        return this.tasksEditable;
    }

    public void setTasksEditable(boolean tasksEditable) {
        this.tasksEditable = tasksEditable;
    }

    public void setTeamWf(IAtsTeamWorkflow teamWf) {
        this.teamWf = teamWf;
    }

    @Override
    public Collection<TeamWorkFlowArtifact> getSelectedTeamWorkflowArtifacts() {
        return Arrays.asList((TeamWorkFlowArtifact)this.teamWf);
    }

    public IAtsTeamWorkflow getTeamWf() {
        return this.teamWf;
    }
}

