/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.ai.IAtsActionableItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsAbstractReview;
import org.eclipse.osee.ats.api.review.ReviewFormalType;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.api.workflow.hooks.IAtsReviewHook;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;

public class NewPeerToPeerReviewJob
extends Job {
    private final TeamWorkFlowArtifact teamParent;
    private final String againstState;
    private final String reviewTitle;
    private ReviewBlockType blockType;
    private ReviewFormalType reviewType;
    private IAtsActionableItem actionableItem;

    public NewPeerToPeerReviewJob(TeamWorkFlowArtifact teamParent, String reviewTitle, String againstState) {
        super("Creating New PeerToPeer Review");
        this.teamParent = teamParent;
        this.againstState = againstState;
        this.reviewTitle = reviewTitle;
    }

    public NewPeerToPeerReviewJob(TeamWorkFlowArtifact teamParent, IAtsActionableItem actionableItem, String reviewTitle, String againstState, ReviewBlockType blockType, ReviewFormalType reviewType) {
        super("Creating New PeerToPeer Review");
        this.teamParent = teamParent;
        this.actionableItem = actionableItem;
        this.againstState = againstState;
        this.reviewTitle = reviewTitle;
        this.blockType = blockType;
        this.reviewType = reviewType;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            try {
                if (this.teamParent != null && this.actionableItem != null) {
                    throw new OseeArgumentException("Either Team Workflow or Actionable Item must be null", new Object[0]);
                }
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("New Peer To Peer Review");
                PeerToPeerReviewArtifact peerArt = null;
                peerArt = this.teamParent != null ? (PeerToPeerReviewArtifact)AtsApiService.get().getReviewService().createNewPeerToPeerReview((IAtsTeamWorkflow)this.teamParent, this.reviewTitle, this.againstState, changes) : (PeerToPeerReviewArtifact)AtsApiService.get().getReviewService().createNewPeerToPeerReview(this.actionableItem, this.reviewTitle, null, new Date(), AtsApiService.get().getUserService().getCurrentUser(), changes);
                if (this.blockType != null) {
                    changes.setSoleAttributeValue((ArtifactId)peerArt, (AttributeTypeToken)AtsAttributeTypes.ReviewBlocks, (Object)this.blockType.name());
                }
                if (this.reviewType != null) {
                    changes.setSoleAttributeValue((ArtifactId)peerArt, (AttributeTypeToken)AtsAttributeTypes.ReviewFormalType, (Object)this.reviewType.name());
                }
                changes.execute();
                for (IAtsReviewHook reviewHook : AtsApiService.get().getReviewService().getReviewHooks()) {
                    reviewHook.reviewCreated((IAtsAbstractReview)peerArt);
                }
                AtsEditors.openATSAction((ArtifactToken)peerArt, AtsOpenOption.OpenOneOrPopupSelect);
            }
            catch (Exception ex) {
                monitor.done();
                Status status = new Status(4, "org.eclipse.osee.ats.ide", -1, "Error creating PeerToPeer Review", (Throwable)ex);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

