/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.operation;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.workflow.ConvertWorkflowStatesOperation;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.Displays;

public class ConvertWorkflowStatesBlam
extends AbstractBlam {
    private static final String SOURCE_TEAM_WORKFLOWS = "Team Workflow(s) (drop here)";
    private static final String FROM_TO_MAP = "From State to State mapping (from:to;from:to)";
    private static final String PERSIST = "Persist (else report only)";

    public void runOperation(final VariableMap variableMap, IProgressMonitor monitor) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    List sourceTeamArts = Collections.castAll(TeamWorkFlowArtifact.class, (Collection)variableMap.getArtifacts(ConvertWorkflowStatesBlam.SOURCE_TEAM_WORKFLOWS));
                    String fromToMapStr = variableMap.getString(ConvertWorkflowStatesBlam.FROM_TO_MAP);
                    boolean persist = variableMap.getBoolean(ConvertWorkflowStatesBlam.PERSIST);
                    if (sourceTeamArts.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must drag in Source Team Workflow(s).");
                        return;
                    }
                    if (fromToMapStr.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"Must enter from/to mappings.");
                        return;
                    }
                    Map<String, String> fromToMap = ConvertWorkflowStatesBlam.this.createFromToMap(fromToMapStr);
                    if (fromToMap == null) {
                        return;
                    }
                    if (fromToMap.isEmpty()) {
                        AWorkbench.popup((String)"ERROR", (String)"No From/To values extracted.");
                        return;
                    }
                    final XResultData rd = new XResultData();
                    ConvertWorkflowStatesOperation operation = new ConvertWorkflowStatesOperation(fromToMap, sourceTeamArts, persist, rd);
                    Operations.executeAsJob((IOperation)operation, (boolean)true, (int)30, (IJobChangeListener)new JobChangeAdapter(){

                        public void done(IJobChangeEvent event) {
                            XResultDataUI.report((XResultData)rd, (String)ConvertWorkflowStatesBlam.this.getName());
                        }
                    });
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                }
            }
        });
    }

    private Map<String, String> createFromToMap(String fromToMapStr) {
        HashMap<String, String> fromToMap = new HashMap<String, String>();
        String[] stringArray = fromToMapStr.split(";");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] fromTo = line.split(":");
            if (fromTo.length != 2 || fromTo[0].isEmpty() || fromTo[1].isEmpty()) {
                AWorkbench.popupf((String)"Invalid from:to values [%s]", (Object[])new Object[]{line});
                return null;
            }
            fromToMap.put(fromTo[0], fromTo[1]);
            ++n2;
        }
        return fromToMap;
    }

    public String getXWidgetsXml() {
        return "<xWidgets><XWidget xwidgetType=\"XListDropViewer\" displayName=\"Team Workflow(s) (drop here)\" /><XWidget xwidgetType=\"XText\" displayName=\"From State to State mapping (from:to;from:to)\" horizontalLabel=\"true\" /><XWidget xwidgetType=\"XCheckBox\" displayName=\"Persist (else report only)\" defaultValue=\"false\"/></xWidgets>";
    }

    public String getDescriptionUsage() {
        return "Takes source Team Workflow(s) and converts state names.  \nUse this BLAM when Work Definition changes require state re-name or removal.  \nThis BLAM will fix old workflows\nNOTE: ATS log will show name changes, but not OSEE history.";
    }

    public String getName() {
        return "Convert Workflow State Names";
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(AtsNavigateViewItems.ATS_ADMIN, XNavItemCat.OSEE_ADMIN);
    }
}

