/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate;

import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.agile.AgileEndpointApi;
import org.eclipse.osee.ats.api.agile.IAgileTeam;
import org.eclipse.osee.ats.api.agile.JaxAgileSprint;
import org.eclipse.osee.ats.api.agile.JaxNewAgileSprint;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.agile.navigate.AgileNavigateItemProvider;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsApiIde;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.widgets.dialog.AtsConfigCheckTreeDialog;
import org.eclipse.osee.ats.ide.workflow.sprint.SprintArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;

public class ConvertVersionToAgileSprint
extends XNavigateItemAction {
    public ConvertVersionToAgileSprint() {
        super("Convert Version(s) to Agile Sprint", AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_SPRINT), new XNavItemCat[]{AgileNavigateItemProvider.AGILE_CONVERSIONS});
    }

    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        LinkedList activeAgileTeams = new LinkedList();
        AtsApiIde client = AtsApiService.get();
        activeAgileTeams.addAll(client.getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.AgileTeam}).andActive(true).getConfigObjects());
        AtsConfigCheckTreeDialog teamDialog = new AtsConfigCheckTreeDialog(this.getName(), "Select Agile Team", activeAgileTeams, true);
        IAgileTeam agileTeam = null;
        if (teamDialog.open() != 0) {
            return;
        }
        agileTeam = (IAgileTeam)teamDialog.getChecked().iterator().next();
        Collection teamDefs = client.getTeamDefinitionService().getTeamDefinitions(agileTeam);
        if (teamDefs.isEmpty()) {
            AWorkbench.popup((String)("No Team Definitions configured for Agile Team " + agileTeam));
            return;
        }
        IAtsTeamDefinition teamDefHoldingVersions = client.getTeamDefinitionService().getTeamDefHoldingVersions((IAtsTeamDefinition)teamDefs.iterator().next());
        Collection versions = client.getVersionService().getVersions(teamDefHoldingVersions);
        AtsConfigCheckTreeDialog versionDialog = new AtsConfigCheckTreeDialog(this.getName(), "Select Version(s)", versions, true);
        Collection selectedVersions = null;
        if (versionDialog.open() != 0) {
            return;
        }
        selectedVersions = versionDialog.getChecked();
        String newTitle = null;
        boolean useVersionTitle = true;
        if (selectedVersions.size() == 1) {
            EntryDialog ed = new EntryDialog(this.getName(), "Enter new Agile Sprint name(s) (comma delimited)");
            ed.setEntry(((IAtsVersion)selectedVersions.iterator().next()).getName());
            if (ed.open() == 0 && Strings.isValid((String)ed.getEntry())) {
                newTitle = ed.getEntry();
                useVersionTitle = false;
            }
        }
        try {
            AgileEndpointApi ageilEp = AtsApiService.get().getServerEndpoints().getAgileEndpoint();
            JaxNewAgileSprint newSprint = new JaxNewAgileSprint();
            long teamId = agileTeam.getId();
            LinkedList sprints = new LinkedList();
            for (IAtsVersion version : selectedVersions) {
                newSprint.setName(useVersionTitle ? version.getName() : newTitle);
                newSprint.setTeamId(teamId);
                Response response = ageilEp.createSprint(new Long(teamId).longValue(), newSprint);
                JaxAgileSprint jaxSprint = null;
                if (response != null) {
                    jaxSprint = (JaxAgileSprint)response.readEntity(JaxAgileSprint.class);
                }
                if (jaxSprint != null) {
                    long id = jaxSprint.getId();
                    SprintArtifact sprint = (SprintArtifact)client.getQueryService().getArtifact(Long.valueOf(id));
                    AtsApiService.get().getQueryServiceIde().getArtifact(sprint).getParent().reloadAttributesAndRelations();
                    IAtsChangeSet changes = client.getStoreService().createAtsChangeSet(this.getName(), client.getUserService().getCurrentUser());
                    Collection teamWfs = client.getRelationResolver().getRelated((IAtsObject)version, AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow);
                    for (ArtifactId teamWf : teamWfs) {
                        changes.relate((Object)sprint, AtsRelationTypes.AgileSprintToItem_AtsItem, (Object)teamWf);
                    }
                    changes.executeIfNeeded();
                    continue;
                }
                AWorkbench.popup((String)"Error creating Agile Team [%s]", (String)(response != null ? response.toString() : ""));
                return;
            }
            AtsEditors.openInAtsWorldEditor(sprints, this.getName());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }
}

