/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.account.admin.internal.validator;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.account.admin.AccountField;
import org.eclipse.osee.account.admin.internal.validator.AbstractValidator;
import org.eclipse.osee.framework.jdk.core.util.Strings;

public class LocalIdValidator
extends AbstractValidator {
    private static final Pattern LOCAL_ID_PATTERN = Pattern.compile("\\d+");

    @Override
    public AccountField getFieldType() {
        return AccountField.LOCAL_ID;
    }

    @Override
    public boolean isValid(String value) {
        boolean result = Strings.isValid((String)value);
        if (result) {
            Matcher matcher = LOCAL_ID_PATTERN.matcher(value);
            result = matcher.matches();
        }
        return result;
    }
}

