/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.orcs.account.admin.internal.oauth;

import java.util.List;
import org.eclipse.osee.account.admin.OseePrincipal;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreBranches;
import org.eclipse.osee.jaxrs.server.security.JaxRsOAuthStorage;
import org.eclipse.osee.jaxrs.server.security.OAuthClient;
import org.eclipse.osee.jaxrs.server.security.OAuthCodeGrant;
import org.eclipse.osee.jaxrs.server.security.OAuthToken;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.logger.Log;
import org.eclipse.osee.orcs.OrcsApi;
import org.eclipse.osee.orcs.account.admin.internal.oauth.AuthCodeGrantStorage;
import org.eclipse.osee.orcs.account.admin.internal.oauth.ClientCredentialStorage;
import org.eclipse.osee.orcs.account.admin.internal.oauth.ClientStorage;
import org.eclipse.osee.orcs.account.admin.internal.oauth.OAuthClientCredential;
import org.eclipse.osee.orcs.account.admin.internal.oauth.TokenStorage;
import org.eclipse.osee.orcs.data.ArtifactReadable;

public class JdbcJaxRsOAuthStorage
implements JaxRsOAuthStorage {
    private Log logger;
    private JdbcService jdbcService;
    private AuthCodeGrantStorage authCodeGrantStorage;
    private TokenStorage tokenStorage;
    private ClientCredentialStorage credentialStorage;
    private ClientStorage clientStorage;
    private OrcsApi orcsApi;

    public void setOrcsApi(OrcsApi orcsApi) {
        this.orcsApi = orcsApi;
    }

    public void setLogger(Log logger) {
        this.logger = logger;
    }

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void start() {
        JdbcClient jdbcClient = this.jdbcService.getClient();
        this.authCodeGrantStorage = new AuthCodeGrantStorage(this.logger, jdbcClient);
        this.tokenStorage = new TokenStorage(this.logger, jdbcClient);
        this.credentialStorage = new ClientCredentialStorage(this.logger, jdbcClient);
        this.clientStorage = new ClientStorage(this.orcsApi, (BranchId)CoreBranches.COMMON);
    }

    private ClientStorage getClientStorage() {
        return this.clientStorage;
    }

    public OAuthCodeGrant getCodeGrant(String code) {
        return this.authCodeGrantStorage.getByCode(code);
    }

    public void storeCodeGrant(OAuthCodeGrant code) {
        this.authCodeGrantStorage.insert(code);
    }

    public void removeCodeGrant(OAuthCodeGrant code) {
        this.authCodeGrantStorage.delete(code);
    }

    public Iterable<OAuthToken> getAccessTokensByRefreshToken(String refreshToken) {
        return this.tokenStorage.getAccessTokenByRefreshToken(refreshToken);
    }

    public OAuthToken getPreauthorizedToken(long clientUuid, long subjectUuid, String grantType) {
        return this.tokenStorage.getPreauthorizedToken(clientUuid, subjectUuid, grantType);
    }

    public void storeToken(OAuthToken ... tokens) {
        this.tokenStorage.insertTokens(tokens);
    }

    public void relateTokens(OAuthToken parentToken, OAuthToken childToken) {
        this.tokenStorage.relateTokens(parentToken, childToken);
    }

    public void removeToken(Iterable<OAuthToken> tokens) {
        this.tokenStorage.deleteToken(tokens);
    }

    public void removeTokenByKey(String tokenKey) {
        this.tokenStorage.deleteTokenByKey(tokenKey);
    }

    public ArtifactId storeClient(OseePrincipal principal, OAuthClient client) {
        ArtifactId clientArtId;
        ClientStorage clientStorage = this.getClientStorage();
        boolean exists = clientStorage.exists(client.getClientUuid());
        if (exists) {
            clientStorage.update(principal, client);
            clientArtId = ArtifactId.valueOf((Long)client.getClientUuid());
        } else {
            clientArtId = clientStorage.insert(principal, client);
        }
        Long clientId = clientArtId.getId();
        ArtifactReadable artifact = (ArtifactReadable)clientStorage.getClientByClientId(clientArtId).getExactlyOne();
        Long applicationId = artifact.getId();
        OAuthClientCredential credential = this.asCredential(clientId, client, applicationId);
        if (this.credentialStorage.getByClientIdAndApplicationId(clientId, (ArtifactId)artifact) != null) {
            this.credentialStorage.update(credential);
        } else {
            this.credentialStorage.insert(credential);
        }
        return clientArtId;
    }

    OAuthClientCredential asCredential(Long clientUuid, OAuthClient client, Long applicationId) {
        long subjectId = client.getSubjectId();
        String clientKey = client.getClientId();
        String clientSecret = client.getClientSecret();
        List clientCerts = client.getApplicationCertificates();
        return this.credentialStorage.newCredential(clientUuid, applicationId, subjectId, clientKey, clientSecret, clientCerts);
    }

    public void removeClient(OseePrincipal principal, OAuthClient client) {
        this.getClientStorage().delete(principal, client);
        OAuthClientCredential credential = this.asCredential(client.getClientUuid(), client, -1L);
        this.credentialStorage.delete(credential);
    }

    public long getClientUuidByKey(String clientKey) {
        OAuthClientCredential credential = this.credentialStorage.getByClientKey(clientKey);
        return credential != null ? credential.getClientId() : -1L;
    }

    public OAuthClient getClientByClientGuid(String guid) {
        OAuthClient client = null;
        ClientStorage clientStorage = this.getClientStorage();
        ArtifactReadable artifact = (ArtifactReadable)clientStorage.getClientByClientGuid(guid).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (artifact.isValid()) {
            OAuthClientCredential credential = this.credentialStorage.getByApplicationId(artifact.getId());
            client = clientStorage.newClient(artifact, credential);
        }
        return client;
    }

    public OAuthClient getClientByClientId(ArtifactId id) {
        OAuthClient client = null;
        ClientStorage clientStorage = this.getClientStorage();
        ArtifactReadable artifact = (ArtifactReadable)clientStorage.getClientByClientId(id).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
        if (artifact.isValid()) {
            OAuthClientCredential credential = this.credentialStorage.getByApplicationId(artifact.getId());
            client = clientStorage.newClient(artifact, credential);
        }
        return client;
    }

    public OAuthClient getClientByClientKey(String clientKey) {
        OAuthClientCredential credential = this.credentialStorage.getByClientKey(clientKey);
        OAuthClient client = null;
        if (credential != null) {
            ArtifactId applicationId = ArtifactId.valueOf((Long)credential.getApplicationId());
            ClientStorage clientStorage = this.getClientStorage();
            ArtifactReadable artifact = (ArtifactReadable)clientStorage.getClientByApplicationId(applicationId).getOneOrDefault((Object)ArtifactReadable.SENTINEL);
            if (artifact.isValid()) {
                client = clientStorage.newClient(artifact, credential);
            }
        }
        return client;
    }
}

