/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.rest.internal.demo;

import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.config.Csci;
import org.eclipse.osee.ats.api.config.TeamDefinition;
import org.eclipse.osee.ats.api.config.WorkType;
import org.eclipse.osee.ats.api.config.tx.IAtsActionableItemArtifactToken;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTx;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxActionableItem;
import org.eclipse.osee.ats.api.config.tx.IAtsConfigTxTeamDef;
import org.eclipse.osee.ats.api.config.tx.IAtsVersionArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactToken;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.data.AtsTaskDefToken;
import org.eclipse.osee.ats.api.demo.AtsDemoOseeTypes;
import org.eclipse.osee.ats.api.demo.DemoArtifactToken;
import org.eclipse.osee.ats.api.demo.DemoWorkDefinitions;
import org.eclipse.osee.ats.api.query.NextRelease;
import org.eclipse.osee.ats.api.query.ReleasedOption;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.AtsWorkDefinitionTokens;
import org.eclipse.osee.ats.api.workflow.cr.TaskEstUtil;
import org.eclipse.osee.ats.core.access.demo.DemoAtsAccessContextTokens;
import org.eclipse.osee.ats.core.task.TaskSetDefinitionTokensDemo;
import org.eclipse.osee.framework.core.data.AccessContextToken;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.core.enums.DemoBranches;
import org.eclipse.osee.framework.core.enums.DemoUsers;
import org.eclipse.osee.framework.jdk.core.type.NamedId;

public class AtsDbConfigAIsAndTeamsDemoOp {
    private final AtsApi atsApi;

    public AtsDbConfigAIsAndTeamsDemoOp(AtsApi atsApi) {
        this.atsApi = atsApi;
    }

    public void run() {
        IAtsConfigTx cfgTx = this.atsApi.getConfigService().createConfigTx("Create Demo Config");
        IAtsConfigTxTeamDef topTeam = cfgTx.createTeamDef(null, AtsArtifactToken.TopTeamDefinition).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        IAtsConfigTxActionableItem topActionableItem = cfgTx.createActionableItem(AtsArtifactToken.TopActionableItem).andActionable(false);
        this.createSawPlTeamConfig(cfgTx, topTeam, topActionableItem);
        this.createSawTeamConfig(cfgTx, topTeam, topActionableItem);
        this.createCisTeamConfig(cfgTx, topTeam, topActionableItem);
        this.createFacilitiesTeamConfig(cfgTx, topTeam, topActionableItem);
        this.createProcessTeamConfig(cfgTx, topTeam, topActionableItem);
        this.createToolsTeamConfig(cfgTx, topTeam, topActionableItem);
        this.createSystemSafetyTeamConfig(cfgTx, topTeam, topActionableItem);
        cfgTx.execute();
        this.createSawPlCrTaskEstUserGroups();
        this.createSawPlCrSequenceConfig();
    }

    private void createSawPlCrSequenceConfig() {
        TeamDefinition crTeamDef = this.atsApi.getTeamDefinitionService().getTeamDefinitionById((ArtifactId)DemoArtifactToken.SAW_PL_CR_TeamDef);
        ArtifactToken teamDefArt = this.atsApi.getQueryService().getArtifact((IAtsObject)crTeamDef);
        IAtsChangeSet changes = this.atsApi.createChangeSet("createSawPlCrSequenceConfig");
        changes.setSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.AtsIdPrefix, (Object)"CR");
        changes.setSoleAttributeValue((ArtifactId)teamDefArt, (AttributeTypeToken)AtsAttributeTypes.AtsIdSequenceName, (Object)"CR_SEQ");
        changes.execute();
        this.atsApi.getQueryService().runUpdate("INSERT INTO osee_sequence (last_sequence, sequence_name) VALUES (1000, 'CR_SEQ')", new Object[0]);
    }

    private void createSawPlCrTaskEstUserGroups() {
        IAtsChangeSet changes = this.atsApi.createChangeSet("createSawPlCrTaskEstUserGroups");
        ArtifactToken reqUserGroup = changes.createArtifact((ArtifactToken)DemoArtifactToken.SAW_PL_CR_TeamDef, CoreArtifactTypes.UserGroup, "Requirements");
        changes.addAttribute((ArtifactId)reqUserGroup, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)TaskEstUtil.TASK_EST_STATIC_ID);
        changes.addAttribute((ArtifactId)reqUserGroup, (AttributeTypeToken)CoreAttributeTypes.Description, (Object)"desc");
        changes.relate((ArtifactId)reqUserGroup, CoreRelationTypes.Users_User, (ArtifactId)DemoUsers.Joe_Smith);
        changes.relate((ArtifactId)reqUserGroup, CoreRelationTypes.Users_User, (ArtifactId)DemoUsers.Kay_Jones);
        changes.relate((ArtifactId)reqUserGroup, AtsRelationTypes.UserGroupToActionableItem_AI, (ArtifactId)DemoArtifactToken.SAW_PL_Requirements_AI);
        ArtifactToken codeUserGroup = changes.createArtifact((ArtifactToken)DemoArtifactToken.SAW_PL_CR_TeamDef, CoreArtifactTypes.UserGroup, "Code");
        changes.addAttribute((ArtifactId)codeUserGroup, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)TaskEstUtil.TASK_EST_STATIC_ID);
        changes.relate((ArtifactId)codeUserGroup, CoreRelationTypes.Users_User, (ArtifactId)DemoUsers.Joe_Smith);
        changes.relate((ArtifactId)codeUserGroup, AtsRelationTypes.UserGroupToActionableItem_AI, (ArtifactId)DemoArtifactToken.SAW_PL_Code_AI);
        ArtifactToken testUserGroup = changes.createArtifact((ArtifactToken)DemoArtifactToken.SAW_PL_CR_TeamDef, CoreArtifactTypes.UserGroup, "SW Test");
        changes.addAttribute((ArtifactId)testUserGroup, (AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)TaskEstUtil.TASK_EST_STATIC_ID);
        changes.relate((ArtifactId)testUserGroup, CoreRelationTypes.Users_User, (ArtifactId)DemoUsers.Alex_Kay);
        changes.relate((ArtifactId)testUserGroup, AtsRelationTypes.UserGroupToActionableItem_AI, (ArtifactId)DemoArtifactToken.SAW_PL_Test_AI);
        changes.execute();
    }

    private void createFacilitiesTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef facilitiesTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.Facilities_Team).andLeads(new UserToken[]{DemoUsers.John_Stevens}).andMembers(new UserToken[]{DemoUsers.John_Stevens, DemoUsers.Steven_Michael, DemoUsers.Michael_John, DemoUsers.Jason_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Simple);
        facilitiesTeam.createChildTeamDef(facilitiesTeam.getTeamDef(), DemoArtifactToken.Facilities_IT_Team).andLeads(new UserToken[]{DemoUsers.Kay_Wheeler}).andMembers(new UserToken[]{DemoUsers.Kay_Wheeler, DemoUsers.Jason_Stevens, DemoUsers.Michael_John, DemoUsers.Jason_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Simple);
        IAtsConfigTxActionableItem facilitiesAI = topActionableItem.createChildActionableItem(DemoArtifactToken.Facilities_Ai).andActionable(true).andTeamDef(DemoArtifactToken.Facilities_Team);
        facilitiesAI.createChildActionableItem("Backups").andActionable(true).andTeamDef(DemoArtifactToken.Facilities_IT_Team);
        facilitiesAI.createChildActionableItem("Break Room").andActionable(true);
        facilitiesAI.createChildActionableItem("Computers").andActionable(true).andTeamDef(DemoArtifactToken.Facilities_IT_Team);
        facilitiesAI.createChildActionableItem("Network").andActionable(true).andTeamDef(DemoArtifactToken.Facilities_IT_Team);
        facilitiesAI.createChildActionableItem("Vending Machines").andActionable(true);
    }

    private void createToolsTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef toolsTeamTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.Tools_Team).andLeads(new UserToken[]{DemoUsers.Jeffery_Kay}).andMembers(new UserToken[]{DemoUsers.Jeffery_Kay, DemoUsers.Roland_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        toolsTeamTeam.createChildTeamDef(toolsTeamTeam.getTeamDef(), DemoArtifactToken.Website_Team).andLeads(new UserToken[]{DemoUsers.Karmen_John}).andMembers(new UserToken[]{DemoUsers.Karmen_John, DemoUsers.Jeffery_Kay, DemoUsers.Roland_Stevens}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Simple);
        IAtsConfigTxActionableItem toolsTeamAI = topActionableItem.createChildActionableItem(DemoArtifactToken.Tools_Ai).andActionable(true).andTeamDef(DemoArtifactToken.Tools_Team);
        toolsTeamAI.createChildActionableItem(DemoArtifactToken.Reader_AI).andActionable(true);
        toolsTeamAI.createChildActionableItem("Results Reporter").andActionable(true);
        toolsTeamAI.createChildActionableItem(DemoArtifactToken.Timesheet_AI).andActionable(true);
        toolsTeamAI.createChildActionableItem("Website").andActionable(true).andTeamDef(DemoArtifactToken.Website_Team);
    }

    private void createSystemSafetyTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.System_Safety_Team).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Jeffery_Kay}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        topActionableItem.createChildActionableItem(DemoArtifactToken.System_Safety_Ai).andTeamDef(DemoArtifactToken.System_Safety_Team).andActionable(true);
    }

    private void createProcessTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.Process_Team).andLeads(new UserToken[]{DemoUsers.Alex_Kay}).andMembers(new UserToken[]{DemoUsers.Keith_Johnson, DemoUsers.Michael_Alex, DemoUsers.Janice_Michael, DemoUsers.Alex_Kay}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default);
        IAtsConfigTxActionableItem processesAI = topActionableItem.createChildActionableItem("Processes").andActionable(false).andTeamDef(DemoArtifactToken.Process_Team);
        processesAI.createChildActionableItem("Coding Standards").andActionable(true);
        processesAI.createChildActionableItem("Config Mgmt").andActionable(true);
        processesAI.createChildActionableItem("New Employee Manual").andActionable(true);
        processesAI.createChildActionableItem("Reviews").andActionable(true);
    }

    private void createSawPlTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef sawPlTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.SAW_PL_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andLeads(new UserToken[]{DemoUsers.Kay_Jason}).andMembers(new UserToken[]{DemoUsers.Kay_Jason, DemoUsers.Michael_John, DemoUsers.Steven_Kohn}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andVersion(DemoArtifactToken.SAW_Product_Line, ReleasedOption.UnReleased, DemoBranches.SAW_PL, NextRelease.Next, new IAtsVersionArtifactToken[0]).andVersion(DemoArtifactToken.SAW_Hardening_Branch, ReleasedOption.UnReleased, DemoBranches.SAW_PL_Hardening_Branch, NextRelease.Next, new IAtsVersionArtifactToken[0]).andRelatedPeerWorkflowDefinition(new NamedId[]{AtsWorkDefinitionTokens.WorkDef_Review_PeerToPeer_Demo});
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_CR_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.ChangeRequest).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Change_Request).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoChangeRequestTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_Code_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Code).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Code).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoCodeTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_HW_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Hardware).andLeads(new UserToken[]{DemoUsers.Jason_Michael}).andMembers(new UserToken[]{DemoUsers.Jason_Michael}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoReqTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_Requirements_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Requirements).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoReqTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_SW_Design_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.SW_Design).andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_SwDesign);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_Test_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Test).andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Test).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoTestTeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_ARB_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.ARB).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_ProductLine).andTeamWorkflowArtifactType(AtsArtifactTypes.TeamWorkflow);
        sawPlTeam.createChildTeamDef(sawPlTeam.getTeamDef(), DemoArtifactToken.SAW_PL_MIM_TeamDef).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.MIM).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_ProductLine).andTeamWorkflowArtifactType(AtsArtifactTypes.TeamWorkflow);
        IAtsConfigTxActionableItem sawPlSwAI = topActionableItem.createChildActionableItem(DemoArtifactToken.SAW_PL_CSCI_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andActionable(false);
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_CR_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.ChangeRequest).andTeamDef(DemoArtifactToken.SAW_PL_CR_TeamDef).andActionable(false);
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_Code_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Code).andTeamDef(DemoArtifactToken.SAW_PL_Code_TeamDef).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV", "Test Page"});
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_Requirements_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Requirements).andTeamDef(DemoArtifactToken.SAW_PL_Requirements_TeamDef).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV"});
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_Test_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Test).andTeamDef(DemoArtifactToken.SAW_PL_Test_TeamDef).andActionable(true).andChildAis(new String[]{"ADT", "COMM", "MSM", "NAV", "RulLists"});
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_SW_Design_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.SW_Design).andActionable(true).andTeamDef(DemoArtifactToken.SAW_PL_SW_Design_TeamDef);
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_HW_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.Hardware).andTeamDef(DemoArtifactToken.SAW_PL_HW_TeamDef).andActionable(true).andChildAis(new String[]{"Adapter", "Case", "Manual", "Screen"});
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_ARB_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.ARB).andTeamDef(DemoArtifactToken.SAW_PL_ARB_TeamDef).andActionable(true);
        sawPlSwAI.createChildActionableItem(DemoArtifactToken.SAW_PL_MIM_AI).andProgram(DemoArtifactToken.SAW_PL_Program).andWorkType(WorkType.MIM).andTeamDef(DemoArtifactToken.SAW_PL_MIM_TeamDef).andActionable(true);
        cfgTx.createProgram(DemoArtifactToken.SAW_PL_Program).andTeamDef(DemoArtifactToken.SAW_PL_TeamDef).and((AttributeTypeToken)AtsAttributeTypes.Description, (Object)"Program object for SAW PL Program").and((AttributeTypeToken)AtsAttributeTypes.Namespace, (Object)"org.demo.saw.pl");
    }

    private void createSawTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef sawSwTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.SAW_SW).andProgram(DemoArtifactToken.SAW_Program).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.teamDefHoldingVersions").andLeads(new UserToken[]{DemoUsers.Kay_Jason}).andMembers(new UserToken[]{DemoUsers.Steven_Kohn, DemoUsers.Michael_John, DemoUsers.Kay_Jason}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andVersion(DemoArtifactToken.SAW_Bld_1, ReleasedOption.Released, DemoBranches.SAW_Bld_1, NextRelease.None, new IAtsVersionArtifactToken[0]).andVersion(DemoArtifactToken.SAW_Bld_2, ReleasedOption.UnReleased, DemoBranches.SAW_Bld_2, NextRelease.Next, new IAtsVersionArtifactToken[0]).andVersion(DemoArtifactToken.SAW_Bld_3, ReleasedOption.UnReleased, DemoBranches.SAW_Bld_3, NextRelease.None, new IAtsVersionArtifactToken[0]).andRelatedPeerWorkflowDefinition(new NamedId[]{AtsWorkDefinitionTokens.WorkDef_Review_PeerToPeer_Demo}).andAccessContexts(new AccessContextToken[]{DemoAtsAccessContextTokens.DEMO_DEFAULT});
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_Code).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Code).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.code").andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Code).andAccessContexts(new AccessContextToken[]{DemoAtsAccessContextTokens.DEMO_CODE_CONTEXT});
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_HW).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Hardware).andLeads(new UserToken[]{DemoUsers.Jason_Michael}).andMembers(new UserToken[]{DemoUsers.Jason_Michael}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoReqTeamWorkflow);
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_Test).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Test).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.test").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Test).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoTestTeamWorkflow).andAccessContexts(new AccessContextToken[]{DemoAtsAccessContextTokens.DEMO_TEST_CONTEXT});
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_SW_Design).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.SW_Design).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.sw.design").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_SwDesign).andRelatedPeerWorkflowDefinition(new NamedId[]{DemoWorkDefinitions.WorkDef_Review_Demo_Peer_SwDesign}).andRelatedTaskWorkflowDefinition(new NamedId[]{DemoWorkDefinitions.WorkDef_Task_Demo_SwDesign, AtsWorkDefinitionTokens.WorkDef_Task_Default}).andTaskSet(new AtsTaskDefToken[]{TaskSetDefinitionTokensDemo.SawSwDesignTestingChecklist, TaskSetDefinitionTokensDemo.SawSwDesignProcessChecklist});
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_Requirements).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Requirements).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"saw.reqirements").andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoReqTeamWorkflow).andAccessContexts(new AccessContextToken[]{DemoAtsAccessContextTokens.DEMO_REQUIREMENT_CONTEXT});
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_Systems_TeamDef).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Systems).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoReqTeamWorkflow);
        sawSwTeam.createChildTeamDef(sawSwTeam.getTeamDef(), DemoArtifactToken.SAW_SubSystems_TeamDef).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.SubSystems).andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoReqTeamWorkflow);
        IAtsConfigTxActionableItem sawSwAI = topActionableItem.createChildActionableItem(DemoArtifactToken.SAW_CSCI_AI).andProgram(DemoArtifactToken.SAW_Program).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).andActionable(false);
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_Code_AI).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Code).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).andTeamDef(DemoArtifactToken.SAW_Code).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV", "Test Page"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_HW_AI).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Hardware).andTeamDef(DemoArtifactToken.SAW_HW).andChildAis(new IAtsActionableItemArtifactToken[]{DemoArtifactToken.Adapter_AI}).andActionable(true).andChildAis(new String[]{"Case", "Manual", "Screen"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_Requirements_AI).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Requirements).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).andTeamDef(DemoArtifactToken.SAW_Requirements).andActionable(true).andChildAis(new String[]{"COMM", "MSM", "NAV"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_Systems_AI).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Systems).andTeamDef(DemoArtifactToken.SAW_Systems_TeamDef).andActionable(true).andAccessContexts(new AccessContextToken[]{DemoAtsAccessContextTokens.DEMO_SYSTEMS_CONTEXT});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_SubSystems_AI).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.SubSystems).andTeamDef(DemoArtifactToken.SAW_SubSystems_TeamDef).andActionable(true).andAccessContexts(new AccessContextToken[]{DemoAtsAccessContextTokens.DEMO_SUBSYSTEMS_CONTEXT});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_Test_AI).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.Test).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).andTeamDef(DemoArtifactToken.SAW_Test).andActionable(true).andChildAis(new String[]{"ADT", "COMM", "MSM", "NAV", "RunLists"});
        sawSwAI.createChildActionableItem(DemoArtifactToken.SAW_SW_Design_AI).andProgram(DemoArtifactToken.SAW_Program).andWorkType(WorkType.SW_Design).andTeamDef(DemoArtifactToken.SAW_SW_Design).andActionable(true);
        cfgTx.createProgram(DemoArtifactToken.SAW_Program).andTeamDef(DemoArtifactToken.SAW_SW).andCsci(new Csci[]{Csci.DP, Csci.SP, Csci.WP}).and((AttributeTypeToken)AtsAttributeTypes.Description, (Object)"Program object for SAW Program").and((AttributeTypeToken)AtsAttributeTypes.Namespace, (Object)"org.demo.saw");
    }

    private void createCisTeamConfig(IAtsConfigTx cfgTx, IAtsConfigTxTeamDef topTeam, IAtsConfigTxActionableItem topActionableItem) {
        IAtsConfigTxTeamDef cisSwTeam = topTeam.createChildTeamDef(topTeam.getTeamDef(), DemoArtifactToken.CIS_SW).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.teamDefHoldingVersions").andLeads(new UserToken[]{DemoUsers.Kay_Jason}).andMembers(new UserToken[]{DemoUsers.Steven_Kohn, DemoUsers.Michael_John, DemoUsers.Kay_Jason}).andWorkDef((NamedId)AtsWorkDefinitionTokens.WorkDef_Team_Default).andVersion(DemoArtifactToken.CIS_Bld_1, ReleasedOption.Released, DemoBranches.CIS_Bld_1, NextRelease.None, new IAtsVersionArtifactToken[0]).andVersion("CIS Bld 2", ReleasedOption.UnReleased, null, NextRelease.Next, new IAtsVersionArtifactToken[0]).andVersion("CIS Bld 3", ReleasedOption.UnReleased, null, NextRelease.None, new IAtsVersionArtifactToken[0]);
        cisSwTeam.createChildTeamDef(cisSwTeam.getTeamDef(), DemoArtifactToken.CIS_Code).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.code").andLeads(new UserToken[]{DemoUsers.Jason_Michael}).andMembers(new UserToken[]{DemoUsers.Jason_Michael}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Code);
        cisSwTeam.createChildTeamDef(cisSwTeam.getTeamDef(), DemoArtifactToken.CIS_Test).and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.test").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Test).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoTestTeamWorkflow);
        cisSwTeam.createChildTeamDef("CIS SW Design").and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.sw.design").andLeads(new UserToken[]{DemoUsers.Kay_Jones}).andMembers(new UserToken[]{DemoUsers.Kay_Jones}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_SwDesign);
        cisSwTeam.createChildTeamDef("CIS Requirements").and((AttributeTypeToken)CoreAttributeTypes.StaticId, (Object)"cis.reqirements").andLeads(new UserToken[]{DemoUsers.Joe_Smith}).andMembers(new UserToken[]{DemoUsers.Joe_Smith}).andWorkDef((NamedId)DemoWorkDefinitions.WorkDef_Team_Demo_Req).andTeamWorkflowArtifactType(AtsDemoOseeTypes.DemoReqTeamWorkflow);
        IAtsConfigTxActionableItem cisSwAI = topActionableItem.createChildActionableItem(DemoArtifactToken.CIS_CSCI).andActionable(false);
        cisSwAI.createChildActionableItem("CIS Code").andActionable(true).andTeamDef(DemoArtifactToken.CIS_Code);
        cisSwAI.createChildActionableItem("CIS Requirements").andActionable(true).andTeamDef("CIS Requirements");
        cisSwAI.createChildActionableItem(DemoArtifactToken.CIS_Test_AI).andActionable(true).andTeamDef(DemoArtifactToken.CIS_Test);
        cisSwAI.createChildActionableItem("CIS SW Design").andActionable(true).andTeamDef("CIS SW Design");
        cfgTx.createProgram(DemoArtifactToken.CIS_Program).andTeamDef(DemoArtifactToken.CIS_SW).and((AttributeTypeToken)AtsAttributeTypes.Description, (Object)"Program object for CIS Program").and((AttributeTypeToken)AtsAttributeTypes.Namespace, (Object)"org.demo.cis");
    }
}

