/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.jaxrs.server.internal.applications;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.core.Application;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitable;
import org.eclipse.osee.jaxrs.server.internal.JaxRsVisitor;
import org.osgi.framework.Bundle;

public abstract class AbstractJaxRsApplicationContainer
implements JaxRsVisitable {
    private final Map<String, JaxRsApplicationEntry> applications = new ConcurrentHashMap<String, JaxRsApplicationEntry>();
    private final String applicationContext;

    public AbstractJaxRsApplicationContainer(String applicationContext) {
        this.applicationContext = applicationContext;
    }

    public String getApplicationContext() {
        return this.applicationContext;
    }

    public void add(String key, Bundle bundle, Application application) {
        JaxRsApplicationEntry entry = new JaxRsApplicationEntry(bundle, application);
        this.applications.put(key, entry);
    }

    public void remove(String key) {
        this.applications.remove(key);
    }

    public boolean isEmpty() {
        return this.applications.isEmpty();
    }

    public int size() {
        return this.applications.size();
    }

    @Override
    public void accept(JaxRsVisitor visitor) {
        visitor.onStartApplicationContainer(this.applicationContext, this.size());
        try {
            for (Map.Entry<String, JaxRsApplicationEntry> entry : this.applications.entrySet()) {
                String componentName = entry.getKey();
                JaxRsApplicationEntry value = entry.getValue();
                Bundle bundle = value.getBundle();
                Application application = value.getApplication();
                visitor.onApplication(this.applicationContext, componentName, bundle, application);
            }
        }
        finally {
            visitor.onEndApplicationContainer();
        }
    }

    protected Application getApplication() {
        JaxRsApplicationEntry entry;
        Application toReturn = null;
        toReturn = this.applications.size() > 1 ? this.newCompositeApplication() : ((entry = this.getFirstEntry()) != null ? entry.getApplication() : null);
        return toReturn;
    }

    private JaxRsApplicationEntry getFirstEntry() {
        return !this.applications.isEmpty() ? this.applications.values().iterator().next() : null;
    }

    private final Application newCompositeApplication() {
        final LinkedHashSet classes = new LinkedHashSet();
        final LinkedHashSet singletons = new LinkedHashSet();
        for (JaxRsApplicationEntry appEntry : this.applications.values()) {
            Application application = appEntry.getApplication();
            classes.addAll(application.getClasses());
            singletons.addAll(application.getSingletons());
        }
        return new Application(){

            public Set<Class<?>> getClasses() {
                return classes;
            }

            public Set<Object> getSingletons() {
                return singletons;
            }
        };
    }

    public String toString() {
        return " applicationContext=" + this.applicationContext;
    }

    private final class JaxRsApplicationEntry {
        private final Bundle bundle;
        private final Application application;

        public JaxRsApplicationEntry(Bundle bundle, Application application) {
            this.bundle = bundle;
            this.application = application;
        }

        public Bundle getBundle() {
            return this.bundle;
        }

        public Application getApplication() {
            return this.application;
        }
    }
}

