/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.ui.internal.dnd;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.graphiti.ui.editor.DiagramBehavior;

public class GFTemplateTransferDropTargetListener
extends TemplateTransferDropTargetListener {
    private DiagramBehavior diagramBehavior;

    public GFTemplateTransferDropTargetListener(EditPartViewer viewer, DiagramBehavior diagramBehavior) {
        super(viewer);
        this.setEnablementDeterminedByCommand(true);
        this.diagramBehavior = diagramBehavior;
    }

    protected void handleDrop() {
        this.updateTargetRequest();
        this.updateTargetEditPart();
        if (this.getTargetEditPart() != null) {
            Command command = this.getCommand();
            if (command != null && command.canExecute()) {
                this.getViewer().getEditDomain().getCommandStack().execute(command);
            } else {
                this.getCurrentEvent().detail = 0;
            }
        } else {
            this.getCurrentEvent().detail = 0;
        }
        if (!this.diagramBehavior.isDirectEditingActive()) {
            this.selectAddedObject();
        }
    }

    private void selectAddedObject() {
        Object model = this.getCreateRequest().getNewObject();
        if (model == null) {
            return;
        }
        EditPartViewer viewer = this.getViewer();
        viewer.getControl().forceFocus();
        Object editpart = viewer.getEditPartRegistry().get(model);
        if (editpart instanceof EditPart) {
            this.getViewer().flush();
            viewer.select((EditPart)editpart);
        }
    }
}

