/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.HasBranchId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.EventTopicTransferType;
import org.eclipse.osee.framework.core.event.NetworkSender;
import org.eclipse.osee.framework.core.event.TopicEvent;
import org.eclipse.osee.framework.core.model.event.DefaultBasicUuidRelationReorder;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactCache;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.AttributeChange;
import org.eclipse.osee.framework.skynet.core.event.model.EventBasicGuidArtifact;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicArtifactTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicAttributeChangeTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationReorderTransfer;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicRelationTransfer;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationEventType;

public class ArtifactTopicEvent
extends TopicEvent
implements HasBranchId {
    public static final String ARTIFACT_TOPIC = "artifact.topic.event";
    private final BranchId branch;
    private NetworkSender networkSender;
    private final List<EventTopicArtifactTransfer> artifacts = new ArrayList<EventTopicArtifactTransfer>();
    private final List<EventTopicRelationTransfer> relations = new ArrayList<EventTopicRelationTransfer>();
    private final Set<EventTopicRelationReorderTransfer> relationReorderRecords = new HashSet<EventTopicRelationReorderTransfer>();
    private final ArtifactEvent.ArtifactEventType reloadEvent;
    public EventTopicTransferType transferType = EventTopicTransferType.BASE;

    public ArtifactTopicEvent(BranchId branch) {
        this(branch, ArtifactEvent.ArtifactEventType.UPDATE_ARTIFACTS);
    }

    public ArtifactTopicEvent(TransactionToken transaction) {
        this(transaction.getBranch(), transaction, ArtifactEvent.ArtifactEventType.UPDATE_ARTIFACTS);
    }

    public ArtifactTopicEvent(BranchId branch, ArtifactEvent.ArtifactEventType reloadEvent) {
        this(branch, TransactionToken.SENTINEL, reloadEvent);
    }

    public ArtifactTopicEvent(BranchId branch, TransactionToken transaction, ArtifactEvent.ArtifactEventType reloadEvent) {
        super(ARTIFACT_TOPIC);
        super.setTransaction((TransactionId)transaction);
        this.branch = branch;
        this.reloadEvent = reloadEvent;
    }

    public boolean isReloadEvent() {
        return ArtifactEvent.ArtifactEventType.RELOAD_ARTIFACTS == this.reloadEvent;
    }

    public BranchId getBranch() {
        return this.branch;
    }

    public Set<EventTopicRelationReorderTransfer> getRelationOrderRecords() {
        return this.relationReorderRecords;
    }

    public TransactionId getTransactionId() {
        return super.getTransaction();
    }

    public List<EventBasicGuidArtifact> getLegacyArtifacts() {
        ArrayList<EventBasicGuidArtifact> toReturn = new ArrayList<EventBasicGuidArtifact>();
        for (EventTopicArtifactTransfer transferArt : this.artifacts) {
            toReturn.add(this.convertTransferArtToEventBasicArt(transferArt));
        }
        return toReturn;
    }

    public List<EventTopicArtifactTransfer> getArtifacts() {
        return this.artifacts;
    }

    private EventBasicGuidArtifact convertTransferArtToEventBasicArt(EventTopicArtifactTransfer transferArt) {
        return new EventBasicGuidArtifact(transferArt.getEventModType(), transferArt.getArtifactToken());
    }

    public List<EventTopicArtifactTransfer> getTransferArtifacts() {
        return this.artifacts;
    }

    public void addArtifact(EventTopicArtifactTransfer transferArt) {
        this.artifacts.add(transferArt);
    }

    public List<EventTopicRelationTransfer> getRelations() {
        return this.relations;
    }

    public void addRelation(EventTopicRelationTransfer topicRel) {
        this.relations.add(topicRel);
    }

    public NetworkSender getNetworkSender() {
        return this.networkSender;
    }

    public void setNetworkSender(NetworkSender value) {
        this.networkSender = value;
    }

    public void addRelationReorder(EventTopicRelationReorderTransfer relationReorder) {
        this.relationReorderRecords.add(relationReorder);
    }

    public boolean isRelAddedChangedDeleted(Artifact artifact) {
        return this.isRelChange(artifact) || this.isRelAdded(artifact) || this.isRelDeletedPurged(artifact);
    }

    public boolean isHasEvent(Artifact artifact) {
        return this.isModified(artifact) || this.isDeletedPurged(artifact) || this.isRelChange(artifact) || this.isRelDeletedPurged(artifact) || this.isRelAdded(artifact);
    }

    public EventModType getEventModType(Artifact artifact) {
        if (this.isHasEvent(artifact)) {
            Iterator<EventTopicArtifactTransfer> iterator;
            if (this.isModified(artifact)) {
                return EventModType.Modified;
            }
            if (this.isDeletedPurged(artifact) && (iterator = this.artifacts.iterator()).hasNext()) {
                EventTopicArtifactTransfer gArt = iterator.next();
                if (gArt.is(EventModType.Deleted) && gArt.getArtifactToken().getId().equals(artifact.getId())) {
                    return EventModType.Deleted;
                }
                return EventModType.Purged;
            }
        } else if (this.isReloaded(artifact)) {
            return EventModType.Reloaded;
        }
        return EventModType.Added;
    }

    public boolean isDeletedPurged(Artifact artifact) {
        for (EventTopicArtifactTransfer gArt : this.artifacts) {
            if (!gArt.is(EventModType.Deleted, EventModType.Purged) || !gArt.getArtifactToken().getId().equals(artifact.getId())) continue;
            return true;
        }
        return false;
    }

    public Collection<Artifact> getRelCacheArtifacts() {
        try {
            return ArtifactCache.getActive(this.getRelationsArts(RelationEventType.ModifiedRationale, RelationEventType.Added, RelationEventType.Deleted, RelationEventType.Purged, RelationEventType.Undeleted), this.getBranch());
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public Collection<Artifact> getCacheArtifacts(EventModType ... eventModTypes) {
        try {
            return ArtifactCache.getActive(this.getAsArtifactIds(eventModTypes), this.branch);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return Collections.emptyList();
        }
    }

    public Collection<Artifact> getRelationOrderArtifacts(RelationTypeToken relationType, ArtifactTypeToken artifactType) {
        HashSet<Artifact> reordered = new HashSet<Artifact>(this.relationReorderRecords.size());
        for (EventTopicRelationReorderTransfer reorder : this.relationReorderRecords) {
            Artifact artifact;
            if (relationType != null && !relationType.equals(reorder.getRelTypeUuid()) || (artifact = ArtifactCache.getActive(reorder.getParentArt().getArtifactToken())) == null || artifactType != null && !artifact.isOfType(new ArtifactTypeId[]{artifactType})) continue;
            reordered.add(artifact);
        }
        return reordered;
    }

    public Collection<Artifact> getRelationOrderArtifacts() {
        return this.getRelationOrderArtifacts(null, null);
    }

    public void addArtifact(Artifact artifact) {
        ArrayList<EventTopicAttributeChangeTransfer> attrChanges = new ArrayList<EventTopicAttributeChangeTransfer>();
        for (AttributeChange attrChange : artifact.getDirtyFrameworkAttributeChanges()) {
            attrChanges.add(FrameworkEventUtil.attributeChangeToTransfer(attrChange));
        }
        EventTopicArtifactTransfer transferArt = FrameworkEventUtil.artifactTransferFactory((BranchId)artifact.getBranch(), artifact, (ArtifactTypeId)artifact.getArtifactType(), EventModType.Modified, null, attrChanges, EventTopicTransferType.MODIFICATION);
        this.artifacts.add(transferArt);
        for (DefaultBasicUuidRelationReorder uuidRelationReorder : artifact.getRelationOrderRecords()) {
            EventTopicRelationReorderTransfer transfer = FrameworkEventUtil.relationReorderBasicToTransfer(uuidRelationReorder, this.getEventModType(artifact));
            this.relationReorderRecords.add(transfer);
        }
    }

    public Collection<EventBasicGuidArtifact> get(EventModType ... eventModTypes) {
        HashSet<EventBasicGuidArtifact> guidArts = new HashSet<EventBasicGuidArtifact>();
        for (EventTopicArtifactTransfer transferArt : this.getTransfer(eventModTypes)) {
            guidArts.add(this.convertTransferArtToEventBasicArt(transferArt));
        }
        return guidArts;
    }

    public Collection<EventTopicArtifactTransfer> getTransfer(EventModType ... eventModTypes) {
        HashSet<EventTopicArtifactTransfer> guidArts = new HashSet<EventTopicArtifactTransfer>();
        for (EventTopicArtifactTransfer transferArt : this.artifacts) {
            EventModType[] eventModTypeArray = eventModTypes;
            int n = eventModTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventModType modType = eventModTypeArray[n2];
                if (transferArt.getEventModType() == modType) {
                    guidArts.add(transferArt);
                }
                ++n2;
            }
        }
        return guidArts;
    }

    public Collection<ArtifactId> getAsArtifactIds(EventModType ... eventModTypes) {
        HashSet<ArtifactId> arts = new HashSet<ArtifactId>();
        for (EventTopicArtifactTransfer transferArt : this.artifacts) {
            EventModType[] eventModTypeArray = eventModTypes;
            int n = eventModTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventModType modType = eventModTypeArray[n2];
                if (transferArt.getEventModType() == modType) {
                    arts.add((ArtifactId)transferArt.getArtifactToken());
                }
                ++n2;
            }
        }
        return arts;
    }

    public boolean containsArtifact(Artifact artifact, EventModType ... eventModTypes) {
        for (EventTopicArtifactTransfer transferArt : this.artifacts) {
            EventModType[] eventModTypeArray = eventModTypes;
            int n = eventModTypes.length;
            int n2 = 0;
            while (n2 < n) {
                EventModType modType = eventModTypeArray[n2];
                if (transferArt.getEventModType() == modType && transferArt.getArtifactToken().equals((Object)artifact)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Collection<ArtifactId> getRelationsArts(RelationEventType ... eventModTypes) {
        HashSet<ArtifactId> arts = new HashSet<ArtifactId>();
        for (EventTopicRelationTransfer transferRel : this.getRelations(eventModTypes)) {
            arts.add(transferRel.getArtAId());
            arts.add(transferRel.getArtBId());
        }
        return arts;
    }

    public Collection<EventTopicRelationTransfer> getRelations(RelationEventType ... eventModTypes) {
        HashSet<EventTopicRelationTransfer> transferRels = new HashSet<EventTopicRelationTransfer>();
        for (EventTopicRelationTransfer transferRel : this.relations) {
            RelationEventType[] relationEventTypeArray = eventModTypes;
            int n = eventModTypes.length;
            int n2 = 0;
            while (n2 < n) {
                RelationEventType modType = relationEventTypeArray[n2];
                if (transferRel.getRelationEventType().equals((Object)modType)) {
                    transferRels.add(transferRel);
                }
                ++n2;
            }
        }
        return transferRels;
    }

    public boolean isReloaded(Artifact artifact) {
        return this.matchesModTypes(artifact, EventModType.Reloaded);
    }

    public boolean isModified(Artifact artifact) {
        return this.matchesModTypes(artifact, EventModType.Modified);
    }

    public boolean isModifiedReloaded(Artifact artifact) {
        return this.matchesModTypes(artifact, EventModType.Modified, EventModType.Reloaded);
    }

    private boolean matchesModTypes(Artifact artifact, EventModType ... eventModTypes) {
        Collection<EventTopicArtifactTransfer> transferArts = this.getTransfer(eventModTypes);
        for (EventTopicArtifactTransfer transferArt : transferArts) {
            if (!transferArt.getArtifactToken().getId().equals(artifact.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isRelChange(Artifact artifact) {
        for (EventTopicRelationTransfer guidRel : this.getRelations(RelationEventType.ModifiedRationale)) {
            if (!guidRel.getArtAId().getId().equals(artifact.getId()) && !guidRel.getArtBId().getId().equals(artifact.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isRelDeletedPurged(Artifact artifact) {
        for (EventTopicRelationTransfer guidRel : this.getRelations(RelationEventType.Deleted, RelationEventType.Purged)) {
            if (!guidRel.getArtAId().getId().equals(artifact.getId()) && !guidRel.getArtBId().getId().equals(artifact.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean isRelAdded(Artifact artifact) {
        for (EventTopicRelationTransfer guidRel : this.getRelations(RelationEventType.Added, RelationEventType.Undeleted)) {
            if (!guidRel.getArtAId().getId().equals(artifact.getId()) && !guidRel.getArtBId().getId().equals(artifact.getId())) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        try {
            return String.format("ArtifactTopicEvent: BG[%s] TrId[%s] ARTS[%s] RELS[%s]", this.branch.getId(), super.getTransaction().getIdString(), this.getArtifactsString(this.artifacts), this.getRelationsString(this.relations));
        }
        catch (Exception ex) {
            return String.format("ArtifactEvent exception: " + ex.getLocalizedMessage(), new Object[0]);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifacts == null ? 0 : this.artifacts.hashCode());
        result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
        result = 31 * result + (this.networkSender == null ? 0 : this.networkSender.hashCode());
        result = 31 * result + (this.relationReorderRecords == null ? 0 : this.relationReorderRecords.hashCode());
        result = 31 * result + (this.relations == null ? 0 : this.relations.hashCode());
        result = 31 * result + (this.reloadEvent == null ? 0 : this.reloadEvent.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ArtifactTopicEvent other = (ArtifactTopicEvent)((Object)obj);
        if (this.artifacts == null ? other.artifacts != null : !this.artifacts.equals(other.artifacts)) {
            return false;
        }
        if (this.branch == null ? other.branch != null : !this.branch.getId().equals(other.branch.getId())) {
            return false;
        }
        if (this.networkSender == null && other.networkSender != null) {
            return false;
        }
        if (this.relationReorderRecords == null ? other.relationReorderRecords != null : !this.relationReorderRecords.equals(other.relationReorderRecords)) {
            return false;
        }
        if (this.relations == null ? other.relations != null : !this.relations.equals(other.relations)) {
            return false;
        }
        return this.reloadEvent == other.reloadEvent;
    }

    private String getArtifactsString(List<EventTopicArtifactTransfer> artifacts) {
        if (artifacts.size() <= 10) {
            return artifacts.toString();
        }
        return String.format(" %d Artifacts (data hidden)", artifacts.size());
    }

    private String getRelationsString(List<EventTopicRelationTransfer> relations) {
        if (relations.size() <= 10) {
            return relations.toString();
        }
        return String.format(" %d Relations (data hidden)", relations.size());
    }
}

